/*
 * Decompiled with CFR 0.152.
 */
package sandyores;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.forgespi.language.ModFileScanData;
import sandyores.SandyoresMod;
import sandyores.SandyoresModVariables;

public class SandyoresModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public SandyoresModElements() {
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("sandyores").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        this.addNetworkMessage(SandyoresModVariables.WorldSavedDataSyncMessage.class, SandyoresModVariables.WorldSavedDataSyncMessage::buffer, SandyoresModVariables.WorldSavedDataSyncMessage::new, SandyoresModVariables.WorldSavedDataSyncMessage::handler);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            SandyoresModVariables.MapVariables mapdata = SandyoresModVariables.MapVariables.get(event.getPlayer().field_70170_p);
            SandyoresModVariables.WorldVariables worlddata = SandyoresModVariables.WorldVariables.get(event.getPlayer().field_70170_p);
            if (mapdata != null) {
                SandyoresMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SandyoresModVariables.WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                SandyoresMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SandyoresModVariables.WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        SandyoresModVariables.WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.field_72995_K && (worlddata = SandyoresModVariables.WorldVariables.get(event.getPlayer().field_70170_p)) != null) {
            SandyoresMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SandyoresModVariables.WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        SandyoresMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final SandyoresModElements elements;
        protected final int sortid;

        public ModElement(SandyoresModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

