/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.common.entity;

import com.farcr.savageandravage.core.registry.SREntities;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class BurningBannerEntity
extends Entity {
    private Boolean blockDestroyed = false;
    private static final DataParameter<Integer> TICKS_TILL_REMOVE = EntityDataManager.func_187226_a(BurningBannerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> BLOCK_POS = EntityDataManager.func_187226_a(BurningBannerEntity.class, (IDataSerializer)DataSerializers.field_187201_k);

    public BurningBannerEntity(EntityType<? extends BurningBannerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public BurningBannerEntity(World worldIn, BlockPos positionIn) {
        super((EntityType)SREntities.BURNING_BANNER.get(), worldIn);
        this.setBannerPosition(positionIn);
        this.setBoundingBoxAndOrPosition(true);
    }

    private void setBoundingBoxAndOrPosition(boolean shouldSetPosition) {
        if (this.getBannerPosition() != null) {
            AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            double xPos = this.getBannerPosition().func_177958_n();
            double yPos = this.getBannerPosition().func_177956_o();
            double zPos = this.getBannerPosition().func_177952_p();
            if (this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177230_c() instanceof BannerBlock) {
                xPos += 0.5;
                yPos += 0.2;
                zPos += 0.5;
                if ((Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 0 || (Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 8) {
                    boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.8, 1.65, 0.4);
                } else if ((Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 1 || (Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 9) {
                    boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.8, 1.65, 0.6);
                } else if ((Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 2 || (Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 10) {
                    boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.8, 1.65, 0.8);
                } else if ((Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 3 || (Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 11) {
                    boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.6, 1.65, 0.8);
                } else if ((Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 4 || (Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 12) {
                    boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.4, 1.65, 0.8);
                } else if ((Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 5 || (Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 13) {
                    boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.6, 1.65, 0.8);
                } else if ((Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 6 || (Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 14) {
                    boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.8, 1.65, 0.8);
                } else if ((Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 7 || (Integer)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208138_am) == 15) {
                    boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.8, 1.65, 0.6);
                }
            }
            if (this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177230_c() instanceof WallBannerBlock) {
                switch ((Direction)this.field_70170_p.func_180495_p(this.getBannerPosition()).func_177229_b((IProperty)BlockStateProperties.field_208157_J)) {
                    default: {
                        boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.9, 1.65, 0.3);
                        xPos += 0.48;
                        yPos -= 0.76;
                        zPos += 0.84;
                        break;
                    }
                    case EAST: {
                        boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.3, 1.65, 0.9);
                        xPos += 0.17;
                        yPos -= 0.76;
                        zPos += 0.5;
                        break;
                    }
                    case SOUTH: {
                        boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.9, 1.65, 0.3);
                        xPos += 0.5;
                        yPos -= 0.76;
                        zPos += 0.17;
                        break;
                    }
                    case WEST: {
                        boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.3, 1.65, 0.9);
                        xPos += 0.84;
                        yPos -= 0.76;
                        zPos += 0.48;
                    }
                }
            }
            this.func_174826_a(boundingBox);
            if (shouldSetPosition) {
                this.setPositionNew(xPos, yPos, zPos);
            }
        }
    }

    public void func_70107_b(double x, double y, double z) {
        this.func_226288_n_(x, y, z);
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217464_b((Entity)this);
        }
    }

    public void setPositionNew(double x, double y, double z) {
        this.func_226288_n_(x, y, z);
        this.setBoundingBoxAndOrPosition(false);
        double halfXSize = this.func_174813_aQ().func_216364_b() / 2.0;
        double YSize = this.func_174813_aQ().func_216360_c();
        double halfZSize = this.func_174813_aQ().func_216362_d() / 2.0;
        this.func_174826_a(new AxisAlignedBB(x - halfXSize, y, z - halfZSize, x + halfXSize, y + YSize, z + halfZSize));
        this.field_70160_al = true;
    }

    public void func_213323_x_() {
    }

    private boolean isOminousBanner(BlockPos positionIn) {
        if (this.field_70170_p.func_180495_p(positionIn).func_177230_c() instanceof AbstractBannerBlock) {
            TranslationTextComponent bannerName;
            TileEntity te = this.field_70170_p.func_175625_s(positionIn);
            BannerTileEntity banner = (BannerTileEntity)te;
            try {
                bannerName = (TranslationTextComponent)banner.func_200200_C_();
            }
            catch (ClassCastException cast) {
                bannerName = null;
            }
            return bannerName.func_150268_i().contains("block.minecraft.ominous_banner");
        }
        return false;
    }

    public void func_70071_h_() {
        this.setTicksTillRemove(this.getTicksTillRemove() - 1);
        if (this.isOminousBanner(this.getBannerPosition())) {
            this.setBoundingBoxAndOrPosition(true);
        }
        if (this.blockDestroyed.booleanValue() || this.getTicksTillRemove() <= 0) {
            this.func_70106_y();
            this.blockDestroyed = true;
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double randomPositionX = this.func_184177_bl().func_197745_a(Direction.Axis.X) + (double)this.field_70170_p.field_73012_v.nextFloat() * this.func_184177_bl().func_216364_b();
                double randomPositionY = this.func_184177_bl().func_197745_a(Direction.Axis.Y) + (double)this.field_70170_p.field_73012_v.nextFloat() * this.func_184177_bl().func_216360_c();
                double randomPositionZ = this.func_184177_bl().func_197745_a(Direction.Axis.Z) + (double)this.field_70170_p.field_73012_v.nextFloat() * this.func_184177_bl().func_216362_d();
                if (this.getTicksTillRemove() > 10) {
                    if (this.field_70170_p.field_73012_v.nextInt(5) == 2) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, randomPositionX, randomPositionY, randomPositionZ - 0.0, 0.0, 0.0, 0.0);
                    }
                    if (this.field_70170_p.field_73012_v.nextInt(5) != 3) continue;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, randomPositionX, randomPositionY, randomPositionZ - 0.0, 0.0, 0.0, 0.0);
                    continue;
                }
                if (this.getTicksTillRemove() >= 10) continue;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, randomPositionX, randomPositionY, randomPositionZ - 0.0, 0.0, 0.0, 0.0);
            }
        } else {
            try {
                if (this.getTicksTillRemove() > 10 && !this.isOminousBanner(this.getBannerPosition())) {
                    this.func_184185_a(SoundEvents.field_187646_bt, 2.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    this.blockDestroyed = true;
                }
            }
            catch (NullPointerException nullPointer) {
                this.blockDestroyed = true;
            }
            if (this.getTicksTillRemove() == 10) {
                this.func_184185_a(SoundEvents.field_187646_bt, 2.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f);
                this.field_70170_p.func_217377_a(this.getBannerPosition(), false);
            }
            if (this.getTicksTillRemove() > 10) {
                this.func_184185_a(SoundEvents.field_187643_bs, 2.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f);
            }
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BLOCK_POS, Optional.empty());
        this.field_70180_af.func_187214_a(TICKS_TILL_REMOVE, (Object)50);
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Size", 0);
        compound.func_74768_a("TicksTillRemove", this.getTicksTillRemove());
        if (this.getBannerPosition() != null) {
            compound.func_218657_a("BannerPosition", (INBT)NBTUtil.func_186859_a((BlockPos)this.getBannerPosition()));
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setTicksTillRemove(compound.func_74762_e("TicksTillRemove"));
        if (compound.func_150297_b("BannerPosition", 10)) {
            this.setBannerPosition(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("BannerPosition")));
        }
    }

    public int getTicksTillRemove() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_TILL_REMOVE);
    }

    public void setTicksTillRemove(int tickCount) {
        this.field_70180_af.func_187227_b(TICKS_TILL_REMOVE, (Object)tickCount);
    }

    @Nullable
    public BlockPos getBannerPosition() {
        return ((Optional)this.field_70180_af.func_187225_a(BLOCK_POS)).orElse(null);
    }

    private void setBannerPosition(@Nullable BlockPos positionIn) {
        this.field_70180_af.func_187227_b(BLOCK_POS, Optional.ofNullable(positionIn));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

