/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.core;

import com.farcr.savageandravage.common.entity.CreeperSporeCloudEntity;
import com.farcr.savageandravage.common.item.SRSpawnEgg;
import com.farcr.savageandravage.core.config.SRConfig;
import com.farcr.savageandravage.core.registry.SRBlocks;
import com.farcr.savageandravage.core.registry.SREntities;
import com.farcr.savageandravage.core.registry.SRItems;
import com.farcr.savageandravage.core.registry.SRParticles;
import com.farcr.savageandravage.core.registry.SRSounds;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.IProjectile;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="savageandravage")
public class SavageAndRavage {
    public static final String MODID = "savageandravage";

    public SavageAndRavage() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SRBlocks.BLOCKS.register(modEventBus);
        SRItems.ITEMS.register(modEventBus);
        SREntities.ENTITIES.register(modEventBus);
        SRParticles.PARTICLES.register(modEventBus);
        SRSounds.SOUNDS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SRConfig.COMMON_SPEC);
        modEventBus.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(EventPriority.LOWEST, this::registerItemColors);
        });
    }

    private void registerItemColors(ColorHandlerEvent.Item event) {
        for (RegistryObject<Item> items : SRItems.SPAWN_EGGS) {
            Item item;
            if (ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, items, (String)"value") == null || !((item = (Item)items.get()) instanceof SRSpawnEgg)) continue;
            event.getItemColors().func_199877_a((itemColor, itemsIn) -> ((SRSpawnEgg)item).func_195983_a(itemsIn), new IItemProvider[]{item});
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        SRBlocks.registerFlammables();
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)SRItems.CREEPER_SPORES.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new CreeperSporeCloudEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        SREntities.registerRendering();
        SREntities.addEntitySpawns();
    }
}

