/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.core.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="savageandravage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SRConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static boolean CreepieGoBigWhenBoom;
    public static boolean CreeperNoDestroyBlocks;
    public static boolean CreepersSpawnCreepiesWhenBoom;
    public static boolean PoisonPotatoCompatEnabled;
    public static boolean PoisonEffect;
    public static double PoisonChance;

    public static void bakeConfig() {
        CreepieGoBigWhenBoom = (Boolean)SRConfig.COMMON.CreepieGoBigWhenBoom.get();
        CreeperNoDestroyBlocks = (Boolean)SRConfig.COMMON.CreeperNoDestroyBlocks.get();
        CreepersSpawnCreepiesWhenBoom = (Boolean)SRConfig.COMMON.CreepersSpawnCreepiesWhenBoom.get();
        PoisonPotatoCompatEnabled = (Boolean)SRConfig.COMMON.PoisonPotatoCompatEnabled.get();
        PoisonEffect = (Boolean)SRConfig.COMMON.PoisonEffect.get();
        PoisonChance = (Double)SRConfig.COMMON.PoisonChance.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            SRConfig.bakeConfig();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue CreepieGoBigWhenBoom;
        public final ForgeConfigSpec.BooleanValue CreeperNoDestroyBlocks;
        public final ForgeConfigSpec.BooleanValue CreepersSpawnCreepiesWhenBoom;
        public final ForgeConfigSpec.BooleanValue PoisonPotatoCompatEnabled;
        public final ForgeConfigSpec.BooleanValue PoisonEffect;
        public final ForgeConfigSpec.DoubleValue PoisonChance;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.CreeperNoDestroyBlocks = builder.translation("savageandravage.config.CreeperNoDestroyBlocks").define("Creepers do not destroy blocks", true);
            this.CreepersSpawnCreepiesWhenBoom = builder.translation("savageandravage.config.CreepersSpawnCreepiesWhenBoom").define("Creepies spawn after creeper explosions", true);
            builder.push("Quark Poisonous Potato Compat");
            this.PoisonPotatoCompatEnabled = builder.comment("If true, creepies can be fed a poisonous potato to stunt their growth when Quark is installed.").translation("savageandravageconfig.QuarkPoisonPotatoCompat").define("Compat enabled", true);
            this.PoisonEffect = builder.comment("If false, the feature will still work but not give creepies poison.").translation("savageandravageconfig.PoisonEffect").define("Poison effect", true);
            this.PoisonChance = builder.comment("This affects the chance to stunt a creepie's growth when a poisonous potato is fed.").translation("savageandravageconfig.PoisonChance").defineInRange("Poison chance", 0.1, 0.0, 1.0);
            builder.pop();
            this.CreepieGoBigWhenBoom = builder.comment("If true, creepies grow significantly larger when they explode.").translation("savageandravage.config.CreepieGoBigWhenBoom").define("Creepie go big when boom", false);
        }
    }
}

