/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.core.events;

import com.farcr.savageandravage.common.advancement.SRTriggers;
import com.farcr.savageandravage.common.entity.BurningBannerEntity;
import com.farcr.savageandravage.common.entity.CreeperSporeCloudEntity;
import com.farcr.savageandravage.common.entity.CreepieEntity;
import com.farcr.savageandravage.common.entity.SkeletonVillagerEntity;
import com.farcr.savageandravage.common.entity.goals.ImprovedCrossbowGoal;
import com.farcr.savageandravage.common.item.GrieferArmorItem;
import com.farcr.savageandravage.core.config.SRConfig;
import com.farcr.savageandravage.core.registry.SREntities;
import com.farcr.savageandravage.core.registry.SRItems;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FireChargeItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="savageandravage")
public class SREvents {
    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PillagerEntity) {
            PillagerEntity pillager = (PillagerEntity)event.getEntity();
            ImprovedCrossbowGoal<PillagerEntity> aiCrossBow = new ImprovedCrossbowGoal<PillagerEntity>(pillager, 1.0, 8.0f, 5.0);
            pillager.field_70714_bg.field_220892_d.stream().map(it -> it.field_220774_a).filter(it -> it instanceof RangedCrossbowAttackGoal).findFirst().ifPresent(crossbowGoal -> {
                pillager.field_70714_bg.func_85156_a(crossbowGoal);
                pillager.field_70714_bg.func_75776_a(3, (Goal)aiCrossBow);
            });
            if (event.getWorld().field_73012_v.nextInt(100) == 0 && !event.getWorld().field_72995_K) {
                pillager.func_184201_a(EquipmentSlotType.OFFHAND, SREvents.createRocket());
                pillager.func_184598_c(Hand.OFF_HAND);
                pillager.func_184642_a(EquipmentSlotType.OFFHAND, 2.0f);
            }
        }
        if (event.getEntity() instanceof AbstractVillagerEntity) {
            AbstractVillagerEntity villager = (AbstractVillagerEntity)event.getEntity();
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, SkeletonVillagerEntity.class, 15.0f, 0.5, 0.5));
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof CreeperEntity && !(event.getEntity() instanceof CreepieEntity)) {
            CreeperEntity creeper = (CreeperEntity)event.getEntity();
            if (event.getSource().func_94541_c()) {
                creeper.func_199701_a_(new ItemStack((IItemProvider)SRItems.CREEPER_SPORES.get(), 1 + creeper.field_70170_p.field_73012_v.nextInt(5)));
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (event.getExplosion().func_94613_c() instanceof CreeperEntity && !(event.getExplosion().func_94613_c() instanceof CreepieEntity)) {
            CreeperEntity creeper = (CreeperEntity)event.getExplosion().func_94613_c();
            if (SRConfig.CreeperNoDestroyBlocks) {
                event.getAffectedBlocks().clear();
            }
            CreeperSporeCloudEntity spores = new CreeperSporeCloudEntity((EntityType<? extends CreeperSporeCloudEntity>)((EntityType)SREntities.CREEPER_SPORE_CLOUD.get()), event.getWorld());
            if (SRConfig.CreepersSpawnCreepiesWhenBoom) {
                spores.cloudSize = (int)(creeper.func_110143_aJ() / 5.0f);
                if (creeper.func_225509_J__()) {
                    spores.cloudSize = (int)(creeper.func_110143_aJ() / 2.0f);
                }
                spores.func_82149_j((Entity)creeper);
                creeper.field_70170_p.func_217376_c((Entity)spores);
            }
        }
    }

    @SubscribeEvent
    public static void handleBlastProof(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float decrease = 0.0f;
        boolean flag = false;
        ItemStack head = entity.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chest = entity.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legs = entity.func_184582_a(EquipmentSlotType.LEGS);
        ItemStack feet = entity.func_184582_a(EquipmentSlotType.FEET);
        if (event.getSource().func_94541_c()) {
            if (head.func_77973_b() == SRItems.GRIEFER_HELMET.get()) {
                decrease += 0.25f;
                flag = true;
                SREvents.blastProtect(head, event.getEntityLiving());
            }
            if (chest.func_77973_b() == SRItems.GRIEFER_CHESTPLATE.get()) {
                decrease += 0.3f;
                flag = true;
                SREvents.blastProtect(chest, event.getEntityLiving());
            }
            if (legs.func_77973_b() == SRItems.GRIEFER_LEGGINGS.get()) {
                decrease += 0.25f;
                flag = true;
                SREvents.blastProtect(legs, event.getEntityLiving());
            }
            if (feet.func_77973_b() == SRItems.GRIEFER_BOOTS.get()) {
                decrease += 0.2f;
                flag = true;
                SREvents.blastProtect(feet, event.getEntityLiving());
            }
            if (flag) {
                event.setAmount(event.getAmount() - event.getAmount() * decrease);
            }
        }
    }

    public static void blastProtect(ItemStack stack, LivingEntity entity) {
        int damage = 22;
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185297_d, (ItemStack)stack) > 0) {
            damage -= EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185297_d, (ItemStack)stack) * 8;
        }
        stack.func_222118_a(damage, entity, onBroken -> onBroken.func_213361_c(stack.getEquipmentSlot()));
    }

    @SubscribeEvent
    public static void handleToolTip(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        int index = 0;
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof GrieferArmorItem) {
            GrieferArmorItem armor = (GrieferArmorItem)item;
            for (int i = 0; i < tooltip.size(); ++i) {
                ITextComponent component = (ITextComponent)tooltip.get(i);
                if (!(component instanceof TranslationTextComponent) || !((TranslationTextComponent)component).func_150268_i().equals("attribute.modifier.plus.0")) continue;
                index = i;
            }
            tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getReductionString() + "% ", new Object[0]).func_150257_a((ITextComponent)new TranslationTextComponent("attribute.name.grieferArmor.explosiveDamageReduction", new Object[0])).func_211708_a(TextFormatting.BLUE));
        }
    }

    @SubscribeEvent
    public static void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        CreepieEntity creepie;
        Item heldItem = event.getItemStack().func_77973_b();
        Entity target = event.getTarget();
        if (target instanceof CreeperEntity && heldItem == Items.field_196167_cx) {
            CreepieEntity creepieEntity = new CreepieEntity((EntityType<? extends CreepieEntity>)((EntityType)SREntities.CREEPIE.get()), event.getWorld());
            creepieEntity.func_82149_j(target);
            if (event.getItemStack().func_82837_s()) {
                creepieEntity.func_200203_b(event.getItemStack().func_200301_q());
            }
            if (!event.getPlayer().field_71075_bZ.field_75098_d) {
                event.getItemStack().func_190918_g(1);
            }
            event.getPlayer().func_184609_a(event.getHand());
            event.getWorld().func_217376_c((Entity)creepieEntity);
        }
        if (target instanceof CreepieEntity && event.getItemStack().func_77973_b() == Items.field_151170_bI && SRConfig.PoisonPotatoCompatEnabled && ModList.get().isLoaded("quark") && !(creepie = (CreepieEntity)target).getPersistentData().func_74767_n("savageandravage:poison_potato_applied")) {
            if (!event.getWorld().field_72995_K) {
                Vec3d pos = creepie.func_213303_ch();
                if (creepie.field_70170_p.field_73012_v.nextDouble() < SRConfig.PoisonChance) {
                    creepie.func_184185_a(SoundEvents.field_187537_bA, 0.5f, 0.25f);
                    creepie.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.2, 0.8, 0.0);
                    creepie.getPersistentData().func_74757_a("savageandravage:poison_potato_applied", true);
                    if (SRConfig.PoisonEffect) {
                        creepie.func_195064_c(new EffectInstance(Effects.field_76436_u, 200));
                    }
                } else {
                    creepie.func_184185_a(SoundEvents.field_187537_bA, 0.5f, 0.5f + creepie.field_70170_p.field_73012_v.nextFloat() / 2.0f);
                    creepie.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.1, 0.0);
                }
                if (!event.getPlayer().func_184812_l_()) {
                    event.getItemStack().func_190918_g(1);
                }
            } else {
                event.getPlayer().func_184609_a(event.getHand());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        CreepieEntity creepie;
        if (event.getEntity() instanceof CreepieEntity && SRConfig.PoisonPotatoCompatEnabled && ModList.get().isLoaded("quark") && (creepie = (CreepieEntity)event.getEntity()).getPersistentData().func_74767_n("savageandravage:poison_potato_applied")) {
            creepie.setGrowingAge(-24000);
        }
    }

    @SubscribeEvent
    public static void onInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldItemStack = event.getItemStack();
        Item heldItem = event.getItemStack().func_77973_b();
        PlayerEntity player = event.getPlayer();
        BlockPos blockPos = event.getPos();
        ResourceLocation pot = new ResourceLocation("savageandravage:potted_" + heldItem.getRegistryName().func_110623_a());
        if (event.getWorld().func_180495_p(blockPos).func_177230_c() == Blocks.field_150457_bL && ForgeRegistries.BLOCKS.containsKey(pot)) {
            event.getWorld().func_175656_a(blockPos, ((Block)ForgeRegistries.BLOCKS.getValue(pot)).func_176223_P());
            event.getPlayer().func_184609_a(event.getHand());
            player.func_195066_a(Stats.field_188088_V);
            if (!event.getPlayer().field_71075_bZ.field_75098_d) {
                heldItemStack.func_190918_g(1);
            }
        }
        if (event.getWorld().func_180495_p(blockPos).func_177230_c() instanceof AbstractBannerBlock && event.getWorld().func_217357_a(BurningBannerEntity.class, new AxisAlignedBB(blockPos)).isEmpty()) {
            TileEntity te = event.getWorld().func_175625_s(blockPos);
            Boolean isFlintAndSteel = heldItem instanceof FlintAndSteelItem;
            Boolean isFireCharge = heldItem instanceof FireChargeItem;
            if (isFlintAndSteel.booleanValue() || isFireCharge.booleanValue()) {
                TranslationTextComponent bannerName;
                BannerTileEntity banner = (BannerTileEntity)te;
                try {
                    bannerName = (TranslationTextComponent)banner.func_200200_C_();
                }
                catch (ClassCastException cast) {
                    bannerName = null;
                }
                if (bannerName.func_150268_i().contains("block.minecraft.ominous_banner")) {
                    if (isFlintAndSteel.booleanValue()) {
                        event.getWorld().func_184133_a(player, blockPos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, new Random().nextFloat() * 0.4f + 0.8f);
                        player.func_184609_a(event.getHand());
                        if (player instanceof ServerPlayerEntity) {
                            CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, blockPos, heldItemStack);
                            heldItemStack.func_222118_a(1, (LivingEntity)player, p_219998_1_ -> p_219998_1_.func_213334_d(event.getHand()));
                        }
                    }
                    if (isFireCharge.booleanValue() && !event.getWorld().func_180495_p(blockPos.func_177972_a(event.getFace())).func_196958_f()) {
                        event.getWorld().func_184133_a(player, blockPos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, (new Random().nextFloat() - new Random().nextFloat()) * 0.2f + 1.0f);
                        player.func_184609_a(event.getHand());
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItemStack.func_190918_g(1);
                        }
                    }
                    if (player instanceof ServerPlayerEntity) {
                        SRTriggers.BURN_BANNER.trigger((ServerPlayerEntity)player);
                    }
                    if (!event.getWorld().field_72995_K) {
                        ServerWorld server = (ServerWorld)event.getWorld();
                        if (server.func_217475_c_(blockPos) == null) {
                            EffectInstance badOmenOnPlayer = event.getPlayer().func_70660_b(Effects.field_220309_E);
                            int i = 1;
                            if (badOmenOnPlayer != null) {
                                i += badOmenOnPlayer.func_76458_c();
                                event.getPlayer().func_184596_c(Effects.field_220309_E);
                            } else {
                                --i;
                            }
                            i = MathHelper.func_76125_a((int)i, (int)0, (int)5);
                            EffectInstance effectinstance = new EffectInstance(Effects.field_220309_E, 120000, i, false, false, true);
                            if (!event.getWorld().func_82736_K().func_223586_b(GameRules.field_223621_x)) {
                                event.getPlayer().func_195064_c(effectinstance);
                            }
                        }
                        event.getWorld().func_217376_c((Entity)new BurningBannerEntity(event.getWorld(), blockPos));
                    }
                }
            }
        }
    }

    public static ItemStack createRocket() {
        ItemStack rocket = new ItemStack((IItemProvider)Items.field_196152_dE);
        ItemStack star = new ItemStack((IItemProvider)Items.field_196153_dF);
        CompoundNBT compoundnbt = star.func_190925_c("Explosion");
        compoundnbt.func_74768_a("Type", FireworkRocketItem.Shape.BURST.func_196071_a());
        CompoundNBT compoundnbt1 = rocket.func_190925_c("Fireworks");
        ListNBT listnbt = new ListNBT();
        CompoundNBT compoundnbt2 = star.func_179543_a("Explosion");
        if (compoundnbt2 != null) {
            listnbt.add((Object)compoundnbt2);
        }
        if (!listnbt.isEmpty()) {
            compoundnbt1.func_218657_a("Explosions", (INBT)listnbt);
        }
        return rocket;
    }
}

