/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.core.registry;

import com.farcr.savageandravage.client.render.CreepieRenderer;
import com.farcr.savageandravage.client.render.NoModelRenderer;
import com.farcr.savageandravage.client.render.RunePrisonRenderer;
import com.farcr.savageandravage.client.render.SkeletonVillagerRenderer;
import com.farcr.savageandravage.client.render.SporeBombRenderer;
import com.farcr.savageandravage.common.entity.BurningBannerEntity;
import com.farcr.savageandravage.common.entity.CreeperSporeCloudEntity;
import com.farcr.savageandravage.common.entity.CreepieEntity;
import com.farcr.savageandravage.common.entity.RunePrisonEntity;
import com.farcr.savageandravage.common.entity.SkeletonVillagerEntity;
import com.farcr.savageandravage.common.entity.block.SporeBombEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="savageandravage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SREntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "savageandravage");
    public static RegistryObject<EntityType<CreepieEntity>> CREEPIE = ENTITIES.register("creepie", () -> EntityType.Builder.func_220322_a(CreepieEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.51f, 1.02f).func_206830_a("savageandravage:creepie"));
    public static RegistryObject<EntityType<SkeletonVillagerEntity>> SKELETON_VILLAGER = ENTITIES.register("skeleton_villager", () -> EntityType.Builder.func_220322_a(SkeletonVillagerEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f).func_206830_a("savageandravage:skeleton_villager"));
    public static RegistryObject<EntityType<CreeperSporeCloudEntity>> CREEPER_SPORE_CLOUD = ENTITIES.register("creeper_spore_cloud", () -> EntityType.Builder.func_220322_a(CreeperSporeCloudEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.25f, 0.25f).func_206830_a("savageandravage:creeper_spore_cloud"));
    public static RegistryObject<EntityType<SporeBombEntity>> SPORE_BOMB = ENTITIES.register("spore_bomb", () -> EntityType.Builder.func_220322_a(SporeBombEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.98f, 0.98f).func_206830_a("savageandravage:spore_bomb"));
    public static RegistryObject<EntityType<BurningBannerEntity>> BURNING_BANNER = ENTITIES.register("burning_banner", () -> EntityType.Builder.func_220322_a(BurningBannerEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_206830_a("savageandravage:burning_banner"));
    public static RegistryObject<EntityType<RunePrisonEntity>> RUNE_PRISON = ENTITIES.register("rune_prison", () -> EntityType.Builder.func_220322_a(RunePrisonEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(1.35f, 0.7f).func_206830_a("savageandravage:rune_prison"));

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRendering() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CREEPIE.get()), CreepieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SKELETON_VILLAGER.get()), SkeletonVillagerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CREEPER_SPORE_CLOUD.get()), NoModelRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SPORE_BOMB.get()), SporeBombRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)BURNING_BANNER.get()), NoModelRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)RUNE_PRISON.get()), RunePrisonRenderer::new);
    }

    public static void addEntitySpawns() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)SKELETON_VILLAGER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        ForgeRegistries.BIOMES.getValues().forEach(SREntities::addSpawns);
    }

    public static void addSpawns(Biome biome) {
        if (biome.func_201856_r() != Biome.Category.NETHER && biome.func_201856_r() != Biome.Category.THEEND && biome.func_201856_r() != Biome.Category.MUSHROOM && biome.func_201856_r() != Biome.Category.NONE) {
            biome.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry((EntityType)SKELETON_VILLAGER.get(), 5, 5, 5));
        }
    }
}

