/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public interface IOutputSlot {
    public boolean canTakeFromOutputSlot(int var1, PlayerEntity var2);

    @Nonnull
    public ItemStack shrinkStackSize(int var1, PlayerEntity var2, int var3);

    public void onPickupFromOutputSlot(int var1, PlayerEntity var2, ItemStack var3);

    public static class SlotOutput
    extends Slot {
        private final IOutputSlot callback;
        private PlayerEntity player;

        public SlotOutput(IInventory inventory, int id, int x, int y, IOutputSlot callback) {
            super(inventory, id, x, y);
            this.callback = callback;
        }

        public void setClicked(PlayerEntity player) {
            this.player = player;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public boolean func_82869_a(PlayerEntity player) {
            return this.callback == null || this.callback.canTakeFromOutputSlot(this.getSlotIndex(), player);
        }

        @Nonnull
        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            if (this.callback != null) {
                this.callback.onPickupFromOutputSlot(this.getSlotIndex(), player, stack);
            }
            this.func_75218_e();
            return stack;
        }

        @Nonnull
        public ItemStack func_75209_a(int amount) {
            if (this.player != null && this.callback != null) {
                ItemStack stack = this.callback.shrinkStackSize(this.getSlotIndex(), this.player, amount);
                this.player = null;
                if (!stack.func_190926_b()) {
                    return stack;
                }
            }
            return super.func_75209_a(amount);
        }
    }
}

