/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.config;

import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.config.CrosshairVisibility;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.PointOfView;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum Perspective {
    FIRST_PERSON(PointOfView.FIRST_PERSON, CrosshairVisibility.ALWAYS),
    THIRD_PERSON_BACK(PointOfView.THIRD_PERSON_BACK, CrosshairVisibility.NEVER),
    THIRD_PERSON_FRONT(PointOfView.THIRD_PERSON_FRONT, CrosshairVisibility.NEVER),
    SHOULDER_SURFING(PointOfView.THIRD_PERSON_BACK, CrosshairVisibility.ALWAYS);

    private final PointOfView pointOfView;
    private final CrosshairVisibility defaultCrosshairVisibility;

    private Perspective(PointOfView pointOfView, CrosshairVisibility defaultCrosshairVisibility) {
        this.pointOfView = pointOfView;
        this.defaultCrosshairVisibility = defaultCrosshairVisibility;
    }

    public PointOfView getPointOfView() {
        return this.pointOfView;
    }

    public CrosshairVisibility getDefaultCrosshairVisibility() {
        return this.defaultCrosshairVisibility;
    }

    public Perspective next() {
        Perspective next = Perspective.values()[(this.ordinal() + 1) % Perspective.values().length];
        if (Config.CLIENT.replaceDefaultPerspective()) {
            if (this == FIRST_PERSON) {
                return SHOULDER_SURFING;
            }
            if (this == SHOULDER_SURFING) {
                return THIRD_PERSON_FRONT;
            }
            if (this == THIRD_PERSON_FRONT) {
                return FIRST_PERSON;
            }
        }
        return next;
    }

    public static Perspective of(PointOfView pointOfView, boolean shoulderSurfing) {
        switch (pointOfView) {
            case FIRST_PERSON: {
                return FIRST_PERSON;
            }
            case THIRD_PERSON_BACK: {
                return shoulderSurfing ? SHOULDER_SURFING : THIRD_PERSON_BACK;
            }
            case THIRD_PERSON_FRONT: {
                return THIRD_PERSON_FRONT;
            }
        }
        return FIRST_PERSON;
    }

    public static Perspective current() {
        return Perspective.of(Minecraft.func_71410_x().field_71474_y.func_243230_g(), ShoulderSurfing.STATE.doShoulderSurfing());
    }
}

