/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.client.gui.GuiHandlerSilentGear;
import net.silentchaos512.gear.compat.evilcraft.EvilCraftCompat;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.event.DropsHandler;
import net.silentchaos512.gear.event.RepairHandler;
import net.silentchaos512.gear.event.ToolBlockPlaceHandler;
import net.silentchaos512.gear.event.VanillaGearHandler;
import net.silentchaos512.gear.event.WorldHandler;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModLootStuff;
import net.silentchaos512.gear.init.ModMaterials;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.init.ModTraits;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.IAOETool;
import net.silentchaos512.gear.world.ModWorldGenerator;
import net.silentchaos512.lib.event.InitialSpawnItems;
import net.silentchaos512.lib.registry.IPhasedInitializer;
import net.silentchaos512.lib.registry.SRegistry;

public class CommonProxy {
    public void preInit(SRegistry registry, FMLPreInitializationEvent event) {
        registry.addRegistrationHandler(ModBlocks::registerAll, Block.class);
        registry.addRegistrationHandler(ModItems::registerAll, Item.class);
        registry.addRegistrationHandler(ModRecipes::registerAll, IRecipe.class);
        ModLootStuff.registerAll(registry);
        registry.addPhasedInitializer((IPhasedInitializer)Config.INSTANCE);
        registry.addPhasedInitializer((IPhasedInitializer)ModTraits.INSTANCE);
        registry.addPhasedInitializer((IPhasedInitializer)ModMaterials.INSTANCE);
        registry.addPhasedInitializer((IPhasedInitializer)VanillaGearHandler.INSTANCE);
        Config.INSTANCE.onPreInit(event);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)SilentGear.instance, (IGuiHandler)new GuiHandlerSilentGear());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ModWorldGenerator(), (int)0);
        MinecraftForge.EVENT_BUS.register((Object)DropsHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)GearData.EventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RepairHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ToolBlockPlaceHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)WorldHandler.INSTANCE);
        registry.preInit(event);
    }

    public void init(SRegistry registry, FMLInitializationEvent event) {
        registry.init(event);
        if (Loader.isModLoaded((String)"evilcraft")) {
            EvilCraftCompat.init();
        }
    }

    public void postInit(SRegistry registry, FMLPostInitializationEvent event) {
        registry.postInit(event);
        if (Config.flaxseedDropWeight > 0) {
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack((Item)ModItems.flaxseeds), (int)Config.flaxseedDropWeight);
        }
        IAOETool.BreakHandler.buildOreBlocksSet();
        InitialSpawnItems.add((ResourceLocation)new ResourceLocation("silentgear", "starter_blueprints"), () -> Config.spawnWithStarterBlueprints ? ModItems.blueprintPackage.getStack() : ItemStack.field_190927_a);
        PartRegistry.getValues().forEach(ItemPart::postInitChecks);
    }
}

