/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import java.util.Collection;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.IStatItem;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.config.ConfigOptionEquipment;
import net.silentchaos512.gear.init.ModMaterials;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.item.ICustomEnchantColor;

public interface ICoreItem
extends IStatItem,
ICustomEnchantColor {
    default public ItemStack construct(Item item, ItemStack ... materials) {
        NonNullList parts = NonNullList.func_191196_a();
        for (ItemStack mat : materials) {
            ItemPartData data = ItemPartData.fromStack(mat);
            if (data == null) continue;
            parts.add(data);
        }
        return this.construct(item, (Collection<ItemPartData>)parts);
    }

    default public ItemStack construct(Item item, Collection<ItemPartData> parts) {
        ItemStack result = new ItemStack(item);
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateStats(result);
        return result;
    }

    default public Item getItem() {
        return (Item)this;
    }

    @Deprecated
    public String getGearClass();

    public GearType getGearType();

    default public ItemPartData getPrimaryPart(ItemStack stack) {
        ItemPartData data = GearData.getPrimaryPart(stack);
        return data != null ? data : ItemPartData.instance(ModMaterials.mainWood);
    }

    @Override
    default public float getStat(ItemStack stack, ItemStat stat) {
        return GearData.getStat(stack, stat);
    }

    @Override
    default public int getStatInt(ItemStack stack, ItemStat stat) {
        return Math.round(GearData.getStat(stack, stat));
    }

    public Set<ItemStat> getRelevantStats(ItemStack var1);

    public ConfigOptionEquipment getConfig();

    public boolean matchesRecipe(Collection<ItemStack> var1);

    default public int getAnimationFrames() {
        return 1;
    }

    default public String getModelKey(ItemStack stack, int animationFrame, ItemPartData ... parts) {
        StringBuilder builder = new StringBuilder(this.getGearClass());
        if (GearHelper.isBroken(stack)) {
            builder.append("_b");
        }
        boolean foundMain = false;
        for (ItemPartData part : parts) {
            if (!1.$assertionsDisabled && part.getPart() == null) {
                throw new AssertionError();
            }
            if (part.getPart() instanceof PartMain) {
                if (foundMain) continue;
                foundMain = true;
                builder.append("|").append(part.getModelIndex(animationFrame));
                continue;
            }
            builder.append("|").append(part.getModelIndex(animationFrame));
        }
        return builder.toString();
    }

    default public String getModelKey(ItemStack stack, int animationFrame) {
        return this.getModelKey(stack, animationFrame, this.getRenderParts(stack));
    }

    public ItemPartData[] getRenderParts(ItemStack var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

