/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartBowstring;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartGrip;
import net.silentchaos512.gear.api.parts.PartPositions;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.parts.PartRod;
import net.silentchaos512.gear.api.parts.PartTip;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.config.ConfigOptionEquipment;
import net.silentchaos512.gear.init.ModMaterials;
import net.silentchaos512.gear.item.ToolHead;
import net.silentchaos512.gear.item.ToolRods;
import net.silentchaos512.gear.util.GearData;

public interface ICoreTool
extends ICoreItem {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)CommonItemStats.HARVEST_LEVEL, (Object)CommonItemStats.HARVEST_SPEED, (Object)CommonItemStats.MELEE_DAMAGE, (Object)CommonItemStats.ATTACK_SPEED, (Object)CommonItemStats.DURABILITY, (Object)CommonItemStats.ENCHANTABILITY, (Object[])new ItemStat[]{CommonItemStats.RARITY});

    @Override
    default public Set<ItemStat> getRelevantStats(@Nonnull ItemStack stack) {
        return RELEVANT_STATS;
    }

    default public int getDamageOnBlockBreak(ItemStack gear, World world, IBlockState state, BlockPos pos) {
        return state.func_185904_a() != Material.field_151584_j && state.func_185887_b(world, pos) > 0.0f ? 1 : 0;
    }

    default public int getDamageOnHitEntity(ItemStack gear, EntityLivingBase target, EntityLivingBase attacker) {
        return 2;
    }

    default public ItemPartData getSecondaryPart(ItemStack stack) {
        ItemPartData data = GearData.getSecondaryPart(stack);
        if (data != null) {
            return data;
        }
        return ItemPartData.instance(ModMaterials.mainWood);
    }

    default public ItemPartData getRodPart(ItemStack stack) {
        for (ItemPartData data : GearData.getConstructionParts(stack)) {
            if (!(data.getPart() instanceof PartRod)) continue;
            return data;
        }
        return ItemPartData.instance(ToolRods.WOOD.getPart());
    }

    @Nullable
    default public ItemPartData getGripPart(ItemStack stack) {
        for (ItemPartData part : GearData.getConstructionParts(stack)) {
            if (!(part.getPart() instanceof PartGrip)) continue;
            return part;
        }
        return null;
    }

    @Nullable
    default public ItemPartData getTipPart(ItemStack stack) {
        for (ItemPartData data : GearData.getConstructionParts(stack)) {
            if (!(data.getPart() instanceof PartTip)) continue;
            return data;
        }
        return null;
    }

    @Nullable
    default public ItemPartData getBowstringPart(ItemStack stack) {
        for (ItemPartData data : GearData.getConstructionParts(stack)) {
            if (!(data.getPart() instanceof PartBowstring)) continue;
            return data;
        }
        return null;
    }

    @Override
    default public boolean matchesRecipe(Collection<ItemStack> parts) {
        ConfigOptionEquipment config = this.getConfig();
        ItemStack head = ItemStack.field_190927_a;
        HashMap<PartType, Integer> partCounts = new HashMap<PartType, Integer>();
        HashMap<PartType, ItemPart> partsFound = new HashMap<PartType, ItemPart>();
        for (ItemStack stack : parts) {
            ItemPart part = PartRegistry.get(stack);
            if (stack.func_77973_b() instanceof ToolHead) {
                if (!head.func_190926_b()) {
                    return false;
                }
                String headClass = ToolHead.getToolClass(stack);
                if (!headClass.equals(this.getGearClass())) {
                    return false;
                }
                head = stack;
                partCounts.put(PartType.MAIN, config.getHeadCount());
                continue;
            }
            if (part != null) {
                PartType type = part.getType();
                if (partsFound.containsKey(type) && partsFound.get(type) != part) {
                    return false;
                }
                int current = partCounts.getOrDefault(type, 0);
                partCounts.put(type, current + 1);
                partsFound.putIfAbsent(type, part);
                continue;
            }
            return false;
        }
        for (PartType type : PartType.getValues()) {
            int required = config.getCraftingPartCount(type);
            int found = partCounts.getOrDefault(type, 0);
            if (!(required == 0 && partsFound.get(type) instanceof IUpgradePart ? found > 1 : required != found)) continue;
            return false;
        }
        return !head.func_190926_b();
    }

    @Override
    default public ItemPartData[] getRenderParts(ItemStack stack) {
        PartDataList parts = GearData.getConstructionParts(stack);
        ArrayList<ItemPartData> list = new ArrayList<ItemPartData>();
        for (IPartPosition position : IPartPosition.RENDER_LAYERS) {
            if (position == PartPositions.HEAD) {
                list.add(this.getPrimaryPart(stack));
                continue;
            }
            if (position == PartPositions.GUARD && this.hasSwordGuard()) {
                list.add(this.getSecondaryPart(stack));
                continue;
            }
            if (position == PartPositions.ROD) {
                list.add(this.getRodPart(stack));
                continue;
            }
            ItemPartData part = parts.firstInPosition(position);
            if (part == null) continue;
            list.add(part);
        }
        return (ItemPartData[])list.stream().filter(Objects::nonNull).toArray(ItemPartData[]::new);
    }

    default public boolean hasSwordGuard() {
        return "sword".equals(this.getGearClass());
    }
}

