/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.UnsignedInts;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetStatModifierEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDisplayProperties;
import net.silentchaos512.gear.api.parts.PartOrigins;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.parts.RepairContext;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.Trait;
import net.silentchaos512.gear.api.traits.TraitRegistry;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.ToolHead;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public abstract class ItemPart {
    private static final Pattern REGEX_TEXTURE_SUFFIX_REPLACE = Pattern.compile("[a-z]+_");
    protected ResourceLocation registryName;
    public static final String NBT_KEY = "Key";
    protected static final ResourceLocation BLANK_TEXTURE = new ResourceLocation("silentgear", "items/blank");
    private static final Gson GSON = new GsonBuilder().create();
    protected Supplier<ItemStack> craftingStack = () -> ItemStack.field_190927_a;
    protected String craftingOreDictName = "";
    protected Supplier<ItemStack> craftingStackSmall = () -> ItemStack.field_190927_a;
    protected String craftingOreDictNameSmall = "";
    protected int tier = 0;
    protected boolean enabled = true;
    protected boolean hidden = false;
    private Map<String, PartDisplayProperties> display = new HashMap<String, PartDisplayProperties>();
    protected TextFormatting nameColor = TextFormatting.GRAY;
    protected String localizedNameOverride = "";
    private final PartOrigins origin;
    protected int modelIndex;
    private static int lastModelIndex = -1;
    protected Multimap<ItemStat, StatInstance> stats = new StatModifierMap();
    protected Map<Trait, Integer> traits = new LinkedHashMap<Trait, Integer>();

    public ItemPart(ResourceLocation registryName, PartOrigins origin) {
        this.registryName = registryName;
        String suffix = REGEX_TEXTURE_SUFFIX_REPLACE.matcher(registryName.func_110623_a()).replaceFirst("");
        this.display.put("all", new PartDisplayProperties(registryName.func_110624_b(), suffix));
        this.modelIndex = ++lastModelIndex;
        this.origin = origin;
        this.loadJsonResources();
    }

    public abstract PartType getType();

    public ItemStack getCraftingStack() {
        return this.craftingStack.get();
    }

    public ItemStack getCraftingStackSmall() {
        return this.craftingStackSmall.get();
    }

    public Collection<StatInstance> getStatModifiers(ItemStat stat, ItemPartData part) {
        ArrayList<StatInstance> mods = new ArrayList<StatInstance>(this.stats.get((Object)stat));
        GetStatModifierEvent event = new GetStatModifierEvent(part, stat, mods);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    public Map<Trait, Integer> getTraits(ItemPartData part) {
        return ImmutableMap.copyOf(this.traits);
    }

    public StatInstance.Operation getDefaultStatOperation(ItemStat stat) {
        return stat == CommonItemStats.HARVEST_LEVEL ? StatInstance.Operation.MAX : StatInstance.Operation.ADD;
    }

    @Deprecated
    public int getRepairAmount(ItemStack gear, ItemPartData part) {
        return (int)this.getRepairAmount(gear, part, RepairContext.QUICK);
    }

    public float getRepairAmount(ItemStack gear, ItemPartData part, RepairContext context) {
        ItemPartData gearPrimary = GearData.getPrimaryPart(gear);
        if (gearPrimary != null && part.part.tier < gearPrimary.part.tier) {
            return 0.0f;
        }
        Collection<StatInstance> mods = this.getStatModifiers(CommonItemStats.DURABILITY, part);
        float durability = CommonItemStats.DURABILITY.compute(0.0f, mods);
        switch (context) {
            case QUICK: {
                return Config.quickRepairFactor * durability;
            }
            case ANVIL: {
                return Config.anvilRepairFactor * durability;
            }
        }
        throw new IllegalArgumentException("Unknown RepairContext: " + (Object)((Object)context));
    }

    public float computeStatValue(ItemStat stat) {
        return this.computeStatValue(stat, ItemPartData.instance(this));
    }

    public float computeStatValue(ItemStat stat, ItemPartData part) {
        return stat.compute(0.0f, this.getStatModifiers(stat, part));
    }

    public boolean matchesForCrafting(ItemStack partRep, boolean matchOreDict) {
        if (partRep.func_190926_b()) {
            return false;
        }
        if (!matchOreDict && partRep.func_77969_a(this.craftingStack.get())) {
            return true;
        }
        if (matchOreDict && !this.craftingOreDictName.isEmpty()) {
            for (int id : OreDictionary.getOreIDs((ItemStack)partRep)) {
                if (!this.craftingOreDictName.equals(OreDictionary.getOreName((int)id))) continue;
                return true;
            }
        }
        return false;
    }

    public abstract IPartPosition getPartPosition();

    public boolean isBlacklisted() {
        return this.isBlacklisted(this.craftingStack.get());
    }

    public boolean isBlacklisted(ItemStack partRep) {
        return !this.enabled;
    }

    @Nullable
    public ResourceLocation getTexture(ItemPartData part, ItemStack gear, String gearClass, IPartPosition position, int animationFrame) {
        PartDisplayProperties props = this.getDisplayProperties(part, gear, animationFrame);
        String path = "items/" + gearClass + "/" + position.getTexturePrefix() + "_" + props.textureSuffix;
        return new ResourceLocation(props.textureDomain, path);
    }

    @Nullable
    public ResourceLocation getBrokenTexture(ItemPartData part, ItemStack gear, String gearClass, IPartPosition position) {
        return this.getTexture(part, gear, gearClass, position, 0);
    }

    public String getModelIndex(ItemPartData part, int animationFrame) {
        return this.modelIndex + (animationFrame == 3 ? "_3" : "");
    }

    public int getColor(ItemPartData part, ItemStack gear, int animationFrame) {
        PartDisplayProperties props = this.getDisplayProperties(part, gear, animationFrame);
        if (!gear.func_190926_b()) {
            if (GearHelper.isBroken(gear)) {
                return props.brokenColor;
            }
            if (GearHelper.shouldUseFallbackColor(gear, part)) {
                return props.fallbackColor;
            }
        }
        return props.textureColor;
    }

    public PartDisplayProperties getDisplayProperties(ItemPartData part, ItemStack gear, int animationFrame) {
        if (!gear.func_190926_b()) {
            GearType gearType;
            GearType gearType2 = gearType = gear.func_77973_b() instanceof ToolHead ? GearType.get(ToolHead.getToolClass(gear)) : ((ICoreItem)gear.func_77973_b()).getGearType();
            if (gearType == null) {
                return this.display.get("all");
            }
            if (this.display.containsKey(gearType.getName())) {
                return this.display.get(gearType.getName());
            }
            for (String key : this.display.keySet()) {
                if (!gearType.matches(key)) continue;
                return this.display.get(key);
            }
        }
        return this.display.get("all");
    }

    public abstract void addInformation(ItemPartData var1, ItemStack var2, World var3, List<String> var4, boolean var5);

    public String getTranslationKey(@Nullable ItemPartData part) {
        return String.format("material.%s.%s.name", this.registryName.func_110624_b(), this.registryName.func_110623_a());
    }

    @Deprecated
    public String getTranslatedName(@Nullable ItemPartData part, ItemStack gear) {
        if (!this.localizedNameOverride.isEmpty()) {
            return this.localizedNameOverride;
        }
        return SilentGear.i18n.translate(this.getTranslationKey(part), new Object[0]);
    }

    public ITextComponent getDisplayName(@Nullable ItemPartData part, ItemStack gear) {
        if (!this.localizedNameOverride.isEmpty()) {
            return new TextComponentString(this.localizedNameOverride);
        }
        return new TextComponentTranslation(this.getTranslationKey(part), new Object[0]);
    }

    @Deprecated
    public abstract String getTypeName();

    public String toString() {
        String str = "ItemPart[" + this.getType().getDebugSymbol() + "]{";
        str = str + "Key: " + this.registryName + ", ";
        str = str + "Origin: " + (Object)((Object)this.origin) + ", ";
        str = str + "CraftingItem: " + this.craftingStack.get() + ", ";
        str = str + "CraftingOreDict: '" + this.craftingOreDictName + "', ";
        str = str + "Tier: " + this.tier;
        str = str + "}";
        return str;
    }

    private String getResourceFileLocation() {
        return String.format("assets/%s/materials/%s.json", this.registryName.func_110624_b(), this.registryName.func_110623_a());
    }

    private void loadJsonResources() {
        String path = this.getResourceFileLocation();
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (resourceAsStream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, "UTF-8"));){
                this.readResourceFile(reader);
            }
            catch (Exception e) {
                SilentGear.log.warn("Error reading part file '{}'", new Object[]{path});
                SilentGear.log.catching((Throwable)e);
            }
        } else if (this.origin.isBuiltin()) {
            SilentGear.log.error("ItemPart '{}' is missing its data file!", new Object[]{this.registryName});
        }
        File file = new File(Config.INSTANCE.getDirectory().getPath(), "materials/" + this.registryName.func_110623_a() + ".json");
        try (BufferedReader reader2 = new BufferedReader(new FileReader(file));){
            this.readResourceFile(reader2);
        }
        catch (FileNotFoundException reader2) {
        }
        catch (Exception e) {
            SilentGear.log.warn("Error reading part override '{}'", new Object[]{file.getAbsolutePath()});
            SilentGear.log.catching((Throwable)e);
        }
    }

    private void readResourceFile(BufferedReader reader) {
        JsonElement je = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
        JsonObject json = je.getAsJsonObject();
        Loader.processJson(this, json);
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.func_74778_a(NBT_KEY, this.registryName.toString());
    }

    @Nullable
    public static ItemPart fromNBT(NBTTagCompound tags) {
        String key = tags.func_74779_i(NBT_KEY);
        return PartRegistry.get(key);
    }

    public void postInitChecks() {
        if (this.getCraftingStack().func_190926_b()) {
            ItemStack fromOredict = this.getCraftingItemFromOreDict();
            if (!fromOredict.func_190926_b()) {
                this.craftingStack = () -> fromOredict;
            } else {
                SilentGear.log.error("Part \"{}\" ({}) has no crafting item.", new Object[]{this.registryName, this.origin});
            }
        }
        if (this.origin == PartOrigins.BUILTIN_CORE && !"silentgear".equals(this.registryName.func_110624_b())) {
            throw new IllegalArgumentException(String.format("Part \"%s\" has origin %s, but should be %s", new Object[]{this.registryName, PartOrigins.BUILTIN_CORE, PartOrigins.BUILTIN_ADDON}));
        }
    }

    private ItemStack getCraftingItemFromOreDict() {
        if (this.craftingOreDictName.isEmpty()) {
            SilentGear.log.error("No crafting item or ore dictionary key for part: {}", new Object[]{this});
            return ItemStack.field_190927_a;
        }
        if (!OreDictionary.doesOreNameExist((String)this.craftingOreDictName)) {
            SilentGear.log.error("Ore dictionary key '{}' does not exist. Part: {}", new Object[]{this.craftingOreDictName, this});
            return ItemStack.field_190927_a;
        }
        NonNullList stacks = OreDictionary.getOres((String)this.craftingOreDictName, (boolean)false);
        if (!stacks.isEmpty()) {
            ItemStack itemStack = (ItemStack)stacks.get(0);
            SilentGear.log.debug("Acquire crafting item from oredict, item={}, part={}", new Object[]{itemStack, this});
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public String getCraftingOreDictName() {
        return this.craftingOreDictName;
    }

    public String getCraftingOreDictNameSmall() {
        return this.craftingOreDictNameSmall;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public TextFormatting getNameColor() {
        return this.nameColor;
    }

    public String getLocalizedNameOverride() {
        return this.localizedNameOverride;
    }

    public PartOrigins getOrigin() {
        return this.origin;
    }

    private static class Loader {
        private Loader() {
        }

        private static void processJson(ItemPart part, JsonObject json) {
            Loader.readStats(part, json);
            Loader.readTraits(part, json);
            Loader.readCraftingItems(part, json);
            Loader.readDisplayProperties(part, json);
            Loader.readAvailability(part, json);
        }

        private static void readStats(ItemPart part, JsonObject json) {
            JsonElement elementStats = json.get("stats");
            if (elementStats != null && elementStats.isJsonArray()) {
                JsonArray array = elementStats.getAsJsonArray();
                StatModifierMap statMap = new StatModifierMap();
                for (JsonElement element : array) {
                    JsonObject obj = element.getAsJsonObject();
                    String name = JsonUtils.func_151219_a((JsonObject)obj, (String)"name", (String)"");
                    ItemStat stat2 = ItemStat.ALL_STATS.get(name);
                    if (stat2 == null) continue;
                    float value = JsonUtils.func_151221_a((JsonObject)obj, (String)"value", (float)0.0f);
                    StatInstance.Operation op = obj.has("op") ? StatInstance.Operation.byName(JsonUtils.func_151200_h((JsonObject)obj, (String)"op")) : part.getDefaultStatOperation(stat2);
                    String id = String.format("mat_%s_%s%d", part.getTranslationKey(null), stat2.getName(), statMap.get(stat2).size() + 1);
                    statMap.put(stat2, new StatInstance(id, value, op));
                }
                statMap.forEach((stat, instance) -> {
                    part.stats.removeAll(stat);
                    part.stats.put(stat, instance);
                });
            }
        }

        private static void readTraits(ItemPart part, JsonObject json) {
            JsonElement elementTraits = json.get("traits");
            if (elementTraits != null && elementTraits.isJsonArray()) {
                JsonArray array = elementTraits.getAsJsonArray();
                HashMap<Trait, Integer> traitsMap = new HashMap<Trait, Integer>();
                for (JsonElement element : array) {
                    int level;
                    JsonObject obj = element.getAsJsonObject();
                    String name = JsonUtils.func_151219_a((JsonObject)obj, (String)"name", (String)"");
                    Trait trait = TraitRegistry.get(name);
                    if (trait == null || (level = MathHelper.func_76125_a((int)JsonUtils.func_151208_a((JsonObject)obj, (String)"level", (int)1), (int)1, (int)trait.getMaxLevel())) <= 0) continue;
                    traitsMap.put(trait, level);
                }
                if (!traitsMap.isEmpty()) {
                    part.traits.clear();
                    part.traits.putAll(traitsMap);
                }
            }
        }

        private static void readCraftingItems(ItemPart part, JsonObject json) {
            JsonElement elementCraftingItems = json.get("crafting_items");
            if (elementCraftingItems != null && elementCraftingItems.isJsonObject()) {
                JsonObject obj;
                JsonObject objTop = elementCraftingItems.getAsJsonObject();
                if (objTop.has("normal") && objTop.get("normal").isJsonObject()) {
                    obj = objTop.get("normal").getAsJsonObject();
                    part.craftingStack = Loader.readItemData(obj);
                    part.craftingOreDictName = JsonUtils.func_151219_a((JsonObject)obj, (String)"oredict", (String)part.craftingOreDictName);
                }
                if (objTop.has("small") && objTop.get("small").isJsonObject()) {
                    obj = objTop.get("small").getAsJsonObject();
                    part.craftingStackSmall = Loader.readItemData(obj);
                    part.craftingOreDictNameSmall = JsonUtils.func_151219_a((JsonObject)obj, (String)"oredict", (String)part.craftingOreDictNameSmall);
                }
            }
        }

        private static void readDisplayProperties(ItemPart part, JsonObject json) {
            JsonElement elementDisplay = json.get("display");
            if (elementDisplay != null && elementDisplay.isJsonObject()) {
                String str;
                JsonObject obj = elementDisplay.getAsJsonObject();
                PartDisplayProperties defaultProps = part.display.getOrDefault("all", PartDisplayProperties.DEFAULT);
                if (!part.display.containsKey("all")) {
                    part.display.put("all", defaultProps);
                }
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (!value.isJsonObject()) continue;
                    JsonObject jsonObject = value.getAsJsonObject();
                    part.display.put(key, PartDisplayProperties.from(jsonObject, defaultProps));
                }
                part.hidden = JsonUtils.func_151209_a((JsonObject)obj, (String)"hidden", (boolean)part.hidden);
                if (obj.has("name_color")) {
                    TextFormatting format = TextFormatting.func_96300_b((String)JsonUtils.func_151200_h((JsonObject)obj, (String)"name_color"));
                    TextFormatting textFormatting = part.nameColor = format != null ? format : part.nameColor;
                }
                if (obj.has("override_localization")) {
                    part.localizedNameOverride = JsonUtils.func_151200_h((JsonObject)obj, (String)"override_localization");
                } else if (obj.has("override_translation")) {
                    part.localizedNameOverride = JsonUtils.func_151200_h((JsonObject)obj, (String)"override_translation");
                }
                if (obj.has("texture_color")) {
                    str = JsonUtils.func_151200_h((JsonObject)obj, (String)"texture_color");
                    defaultProps.textureColor = PartDisplayProperties.readColorCode(str);
                }
                if (obj.has("broken_color")) {
                    str = JsonUtils.func_151200_h((JsonObject)obj, (String)"broken_color");
                    defaultProps.brokenColor = PartDisplayProperties.readColorCode(str);
                }
                if (obj.has("fallback_color")) {
                    str = JsonUtils.func_151200_h((JsonObject)obj, (String)"fallback_color");
                    defaultProps.fallbackColor = PartDisplayProperties.readColorCode(str);
                }
                if (obj.has("texture_domain")) {
                    defaultProps.textureDomain = JsonUtils.func_151200_h((JsonObject)obj, (String)"texture_domain");
                }
                if (obj.has("texture_suffix")) {
                    defaultProps.textureSuffix = JsonUtils.func_151200_h((JsonObject)obj, (String)"texture_suffix");
                }
            }
        }

        private static void readAvailability(ItemPart part, JsonObject json) {
            JsonElement elementAvailability = json.get("availability");
            if (elementAvailability != null && elementAvailability.isJsonObject()) {
                JsonObject obj = elementAvailability.getAsJsonObject();
                part.enabled = JsonUtils.func_151209_a((JsonObject)obj, (String)"enabled", (boolean)part.enabled);
                part.tier = JsonUtils.func_151208_a((JsonObject)obj, (String)"tier", (int)part.tier);
            }
        }

        @Deprecated
        private static void readColorMap(Map<String, Integer> map, int fallback, JsonElement jsonElement) {
            if (jsonElement.isJsonPrimitive()) {
                int color = Loader.readColorCode(jsonElement.getAsString());
                map.put("all", color);
            } else if (jsonElement.isJsonObject()) {
                JsonObject json = jsonElement.getAsJsonObject();
                json.entrySet().forEach(entry -> {
                    int color = Loader.readColorCode(((JsonElement)entry.getValue()).getAsString());
                    map.put((String)entry.getKey(), color);
                });
            } else {
                SilentGear.log.error("Could not read color map, unknown element type: " + jsonElement, new Object[0]);
            }
            if (!map.containsKey("all")) {
                map.put("all", fallback);
            }
        }

        @Deprecated
        private static int readColorCode(String str) {
            try {
                return UnsignedInts.parseUnsignedInt((String)str, (int)16);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                return 0xFFFFFF;
            }
        }

        private static Supplier<ItemStack> readItemData(JsonObject json) {
            if (!json.has("item")) {
                return () -> ItemStack.field_190927_a;
            }
            String itemName = JsonUtils.func_151200_h((JsonObject)json, (String)"item");
            int meta = JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0);
            return () -> {
                Item item = Item.func_111206_d((String)itemName);
                return item == null ? ItemStack.field_190927_a : new ItemStack(item, 1, meta);
            };
        }
    }
}

