/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartBowstring;
import net.silentchaos512.gear.api.parts.PartGrip;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.parts.PartRod;
import net.silentchaos512.gear.api.parts.PartTip;
import net.silentchaos512.gear.api.parts.RepairContext;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.Trait;

public final class ItemPartData {
    private static final Map<ResourceLocation, ItemPartData> CACHE_UNGRADED_PARTS = new HashMap<ResourceLocation, ItemPartData>();
    final ItemPart part;
    final MaterialGrade grade;
    final ItemStack craftingItem;

    private ItemPartData(ItemPart part, MaterialGrade grade, ItemStack craftingItem) {
        this.part = part;
        this.grade = grade;
        this.craftingItem = craftingItem.func_77946_l();
        this.craftingItem.func_190920_e(1);
    }

    public static ItemPartData instance(ItemPart part) {
        ResourceLocation registryName = part.getRegistryName();
        if (CACHE_UNGRADED_PARTS.containsKey(registryName)) {
            return CACHE_UNGRADED_PARTS.get(registryName);
        }
        ItemPartData data = new ItemPartData(part, MaterialGrade.NONE, part.getCraftingStack());
        CACHE_UNGRADED_PARTS.put(registryName, data);
        return data;
    }

    public static ItemPartData instance(ItemPart part, MaterialGrade grade) {
        return new ItemPartData(part, grade, part.getCraftingStack());
    }

    public static ItemPartData instance(ItemPart part, MaterialGrade grade, ItemStack craftingItem) {
        return new ItemPartData(part, grade, craftingItem);
    }

    @Nullable
    public static ItemPartData fromStack(ItemStack craftingItem) {
        ItemPart part = PartRegistry.get(craftingItem);
        if (part == null) {
            return null;
        }
        MaterialGrade grade = MaterialGrade.fromStack(craftingItem);
        return ItemPartData.instance(part, grade, craftingItem);
    }

    @Nullable
    public static ItemPartData readFromNBT(NBTTagCompound tags) {
        ItemPart part = ItemPart.fromNBT(tags);
        if (part == null) {
            return null;
        }
        MaterialGrade grade = MaterialGrade.fromString(tags.func_74779_i("Grade"));
        ItemStack craftingItem = new ItemStack(tags.func_74775_l("Item"));
        return ItemPartData.instance(part, grade, craftingItem);
    }

    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tags) {
        this.part.writeToNBT(tags);
        if (this.grade != MaterialGrade.NONE) {
            tags.func_74778_a("Grade", this.grade.name());
        }
        NBTTagCompound itemTag = new NBTTagCompound();
        this.craftingItem.func_77955_b(itemTag);
        tags.func_74782_a("Item", (NBTBase)itemTag);
        return tags;
    }

    public Collection<StatInstance> getStatModifiers(ItemStat stat) {
        return this.part.getStatModifiers(stat, this);
    }

    public float computeStat(ItemStat stat) {
        return stat.compute(0.0f, this.getStatModifiers(stat));
    }

    public float getRepairAmount(ItemStack gear, RepairContext context) {
        return this.part.getRepairAmount(gear, this, context);
    }

    @Nullable
    public ResourceLocation getTexture(ItemStack gear, String gearClass, IPartPosition position, int animationFrame) {
        return this.part.getTexture(this, gear, gearClass, position, animationFrame);
    }

    @Nullable
    public ResourceLocation getBrokenTexture(ItemStack gear, String gearClass, IPartPosition position) {
        return this.part.getBrokenTexture(this, gear, gearClass, position);
    }

    public int getColor(ItemStack gear, int animationFrame) {
        return this.part.getColor(this, gear, animationFrame);
    }

    public TextFormatting getNameColor() {
        return this.part.getNameColor();
    }

    public String getModelIndex(int animationFrame) {
        return this.part.getModelIndex(this, animationFrame);
    }

    public Map<Trait, Integer> getTraits() {
        return this.part.getTraits(this);
    }

    @Deprecated
    public String getTranslatedName(ItemStack gear) {
        return this.part.getTranslatedName(this, gear);
    }

    public ITextComponent getDisplayName(ItemStack gear) {
        return this.part.getDisplayName(this, gear);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemPartData) {
            ItemPartData other = (ItemPartData)obj;
            return this.part == other.part && this.grade == other.grade && this.craftingItem.func_77969_a(other.craftingItem);
        }
        return super.equals(obj);
    }

    public boolean isMain() {
        return this.part instanceof PartMain;
    }

    public boolean isRod() {
        return this.part instanceof PartRod;
    }

    public boolean isTip() {
        return this.part instanceof PartTip;
    }

    public boolean isGrip() {
        return this.part instanceof PartGrip;
    }

    public boolean isBowstring() {
        return this.part instanceof PartBowstring;
    }

    public String toString() {
        return "ItemPartData{part=" + this.part + ", grade=" + (Object)((Object)this.grade) + ", craftingItem=" + this.craftingItem + "}";
    }

    public ItemPart getPart() {
        return this.part;
    }

    public MaterialGrade getGrade() {
        return this.grade;
    }

    public ItemStack getCraftingItem() {
        return this.craftingItem;
    }
}

