/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gear.SilentGear;

public enum MaterialGrade {
    NONE(0),
    E(-8),
    D(-4),
    C(0),
    B(5),
    A(10),
    S(20),
    SS(30),
    SSS(40);

    private static final String NBT_KEY = "silentgear_grade";
    public final int bonusPercent;

    private MaterialGrade(int bonusPercent) {
        this.bonusPercent = bonusPercent;
    }

    public static MaterialGrade fromStack(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_KEY)) {
            String str = stack.func_77978_p().func_74779_i(NBT_KEY);
            return MaterialGrade.fromString(str);
        }
        return NONE;
    }

    public static MaterialGrade fromString(String str) {
        if (!str.isEmpty()) {
            for (MaterialGrade grade : MaterialGrade.values()) {
                if (!grade.name().equalsIgnoreCase(str)) continue;
                return grade;
            }
        }
        return NONE;
    }

    public static MaterialGrade selectRandom(Random random) {
        return MaterialGrade.selectRandom(random, SSS);
    }

    public static MaterialGrade selectRandom(Random random, MaterialGrade maxGrade) {
        return MaterialGrade.selectRandom(random, B, 1.5, maxGrade);
    }

    public static MaterialGrade selectRandom(Random random, MaterialGrade median, double stdDev, MaterialGrade maxGrade) {
        int val = (int)(stdDev * random.nextGaussian() + (double)median.ordinal());
        val = MathHelper.func_76125_a((int)val, (int)1, (int)maxGrade.ordinal());
        return MaterialGrade.values()[val];
    }

    public void setGradeOnStack(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a(NBT_KEY, this.name());
        }
    }

    public String getTranslatedName() {
        return SilentGear.i18n.translate("stat", "grade." + this.name(), new Object[0]);
    }
}

