/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDisplayProperties;
import net.silentchaos512.gear.api.parts.PartOrigins;
import net.silentchaos512.gear.api.parts.PartPositions;
import net.silentchaos512.gear.api.parts.PartType;

public final class PartBowstring
extends ItemPart {
    public PartBowstring(ResourceLocation name, PartOrigins origin) {
        super(name, origin);
    }

    @Override
    public PartType getType() {
        return PartType.BOWSTRING;
    }

    @Override
    public IPartPosition getPartPosition() {
        return PartPositions.BOWSTRING;
    }

    @Override
    public ResourceLocation getTexture(ItemPartData part, ItemStack gear, String gearClass, IPartPosition position, int animationFrame) {
        if (!"bow".equals(gearClass)) {
            return BLANK_TEXTURE;
        }
        PartDisplayProperties props = this.getDisplayProperties(part, gear, animationFrame);
        String path = String.format("items/%s/%s_%s_%d", gearClass, position.getTexturePrefix(), props.textureSuffix, animationFrame);
        return new ResourceLocation(props.textureDomain, path);
    }

    @Override
    @Nullable
    public ResourceLocation getBrokenTexture(ItemPartData part, ItemStack gear, String gearClass, IPartPosition position) {
        return null;
    }

    @Override
    public String getModelIndex(ItemPartData part, int animationFrame) {
        return this.modelIndex + "_" + animationFrame;
    }

    @Override
    public void addInformation(ItemPartData part, ItemStack gear, World world, @Nonnull List<String> tooltip, boolean advanced) {
    }

    @Override
    public String getTypeName() {
        return "bowstring";
    }
}

