/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartMain;

public final class PartDataList
implements List<ItemPartData> {
    private final List<ItemPartData> list = new ArrayList<ItemPartData>();

    private PartDataList() {
    }

    public static PartDataList of(Collection<ItemPartData> c) {
        PartDataList ret = new PartDataList();
        ret.list.addAll(c);
        return ret;
    }

    public static PartDataList of(ItemPartData ... parts) {
        PartDataList ret = new PartDataList();
        Collections.addAll(ret.list, parts);
        return ret;
    }

    public static PartDataList from(Collection<ItemStack> stacks) {
        PartDataList ret = new PartDataList();
        stacks.stream().map(ItemPartData::fromStack).filter(Objects::nonNull).forEach(data -> ret.list.add((ItemPartData)data));
        return ret;
    }

    public PartDataList getUniqueParts(boolean mainsOnly) {
        PartDataList result = PartDataList.of(new ItemPartData[0]);
        for (ItemPartData data : mainsOnly ? this.getMains() : this.list) {
            if (!result.stream().map(ItemPartData::getPart).noneMatch(part -> part == data.part)) continue;
            result.add(data);
        }
        return result;
    }

    @Nullable
    public ItemPartData firstInPosition(IPartPosition position) {
        for (ItemPartData part : this.list) {
            if (part.part.getPartPosition() != position) continue;
            return part;
        }
        return null;
    }

    @Nullable
    public ItemPartData getPrimaryMain() {
        for (ItemPartData data : this.list) {
            if (!(data.part instanceof PartMain)) continue;
            return data;
        }
        return null;
    }

    public List<ItemPartData> getMains() {
        return this.getParts(ItemPartData::isMain);
    }

    public List<ItemPartData> getRods() {
        return this.getParts(ItemPartData::isRod);
    }

    public List<ItemPartData> getTips() {
        return this.getParts(ItemPartData::isTip);
    }

    public List<ItemPartData> getParts(Predicate<ItemPartData> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.list.stream().filter(predicate).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public boolean addPart(ItemPart part) {
        return this.list.add(ItemPartData.instance(part));
    }

    @Override
    public boolean add(ItemPartData arg0) {
        return this.list.add(arg0);
    }

    @Override
    public void add(int arg0, ItemPartData arg1) {
        this.list.add(arg0, arg1);
    }

    @Override
    public boolean addAll(Collection<? extends ItemPartData> arg0) {
        return this.list.addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends ItemPartData> arg1) {
        return this.list.addAll(arg0, arg1);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.list.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.list.containsAll(arg0);
    }

    @Override
    public ItemPartData get(int arg0) {
        return this.list.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.list.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<ItemPartData> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.list.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<ItemPartData> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<ItemPartData> listIterator(int arg0) {
        return this.list.listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.list.remove(arg0);
    }

    @Override
    public ItemPartData remove(int arg0) {
        return this.list.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.list.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.list.retainAll(arg0);
    }

    @Override
    public ItemPartData set(int arg0, ItemPartData arg1) {
        return this.list.set(arg0, arg1);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<ItemPartData> subList(int arg0, int arg1) {
        return this.list.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.list.toArray(arg0);
    }
}

