/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import com.google.common.primitives.UnsignedInts;
import com.google.gson.JsonObject;
import java.util.regex.Pattern;
import net.minecraft.util.JsonUtils;

public final class PartDisplayProperties {
    public static final PartDisplayProperties DEFAULT = new PartDisplayProperties();
    private static final Pattern REGEX_TEXTURE_SUFFIX_REPLACE = Pattern.compile("[a-z]+_");
    String textureDomain;
    String textureSuffix;
    int textureColor;
    int brokenColor;
    int fallbackColor;
    boolean highlight;

    private PartDisplayProperties() {
        this.textureSuffix = "";
        this.textureDomain = "";
        this.fallbackColor = 0xFFFFFF;
        this.brokenColor = 0xFFFFFF;
        this.textureColor = 0xFFFFFF;
    }

    public PartDisplayProperties(String textureDomain, String textureSuffix) {
        this(textureDomain, textureSuffix, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF);
    }

    public PartDisplayProperties(String textureDomain, String textureSuffix, int textureColor, int brokenColor, int fallbackColor) {
        this.textureDomain = textureDomain;
        this.textureSuffix = textureSuffix;
        this.textureColor = textureColor;
        this.brokenColor = brokenColor;
        this.fallbackColor = fallbackColor;
    }

    public static PartDisplayProperties from(JsonObject json, PartDisplayProperties defaultProps) {
        int textureColor;
        String textureDomain = JsonUtils.func_151219_a((JsonObject)json, (String)"texture_domain", (String)defaultProps.textureDomain);
        String textureSuffix = JsonUtils.func_151219_a((JsonObject)json, (String)"texture_suffix", (String)defaultProps.textureSuffix);
        int brokenColor = textureColor = PartDisplayProperties.readColorCode(JsonUtils.func_151219_a((JsonObject)json, (String)"texture_color", (String)Integer.toHexString(defaultProps.textureColor)));
        if (json.has("broken_color")) {
            brokenColor = PartDisplayProperties.readColorCode(JsonUtils.func_151219_a((JsonObject)json, (String)"broken_color", (String)Integer.toHexString(defaultProps.brokenColor)));
        }
        int fallbackColor = brokenColor;
        if (json.has("fallback_color")) {
            fallbackColor = PartDisplayProperties.readColorCode(JsonUtils.func_151219_a((JsonObject)json, (String)"fallback_color", (String)Integer.toHexString(defaultProps.fallbackColor)));
        }
        PartDisplayProperties props = new PartDisplayProperties(textureDomain, textureSuffix, textureColor, brokenColor, fallbackColor);
        props.highlight = JsonUtils.func_151209_a((JsonObject)json, (String)"highlight", (boolean)props.highlight);
        return props;
    }

    static int readColorCode(String str) {
        try {
            return UnsignedInts.parseUnsignedInt((String)str, (int)16);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return 0xFFFFFF;
        }
    }

    public boolean hasHighlight() {
        return this.highlight;
    }

    public String toString() {
        return "PartDisplayProperties{textureDomain='" + this.textureDomain + '\'' + ", textureSuffix='" + this.textureSuffix + '\'' + ", textureColor=" + Integer.toHexString(this.textureColor) + ", brokenColor=" + Integer.toHexString(this.brokenColor) + ", fallbackColor=" + Integer.toHexString(this.fallbackColor) + ", highlight=" + this.highlight + '}';
    }

    public String getTextureDomain() {
        return this.textureDomain;
    }

    public String getTextureSuffix() {
        return this.textureSuffix;
    }

    public int getTextureColor() {
        return this.textureColor;
    }

    public int getBrokenColor() {
        return this.brokenColor;
    }

    public int getFallbackColor() {
        return this.fallbackColor;
    }
}

