/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRod;

public final class PartRegistry {
    private static Map<String, ItemPart> map = new LinkedHashMap<String, ItemPart>();
    private static ImmutableList<PartMain> mains = null;
    private static ImmutableList<PartRod> rods = null;
    private static ImmutableList<PartMain> visibleMains = null;
    private static ImmutableList<PartRod> visibleRods = null;
    private static Map<String, ItemPart> STACK_TO_PART = new HashMap<String, ItemPart>();
    private static int highestMainPartTier = 0;

    private PartRegistry() {
        throw new IllegalAccessError("Utility class");
    }

    @Nullable
    public static ItemPart get(String key) {
        return map.get(key);
    }

    @Nullable
    public static ItemPart get(ResourceLocation key) {
        return map.get(key.toString());
    }

    @Nullable
    public static ItemPart get(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        String key = stack.func_77973_b().func_77658_a() + "@" + stack.func_77952_i();
        if (STACK_TO_PART.containsKey(key)) {
            return STACK_TO_PART.get(key);
        }
        ItemPart part = PartRegistry.getPart(key, stack, false);
        return part != null ? part : PartRegistry.getPart(key, stack, true);
    }

    @Nullable
    private static ItemPart getPart(String key, ItemStack stack, boolean matchOreDict) {
        for (ItemPart part : map.values()) {
            if (!part.matchesForCrafting(stack, matchOreDict)) continue;
            STACK_TO_PART.put(key, part);
            return part;
        }
        return null;
    }

    public static <T extends ItemPart> T putPart(@Nonnull T part) {
        String key = part.registryName.toString();
        if (map.containsKey(key)) {
            throw new IllegalArgumentException("Already have a part with key " + part.registryName);
        }
        map.put(key, part);
        if (part instanceof PartMain && part.getTier() > highestMainPartTier) {
            highestMainPartTier = part.getTier();
        }
        return part;
    }

    public static Set<String> getKeySet() {
        return map.keySet();
    }

    public static Collection<ItemPart> getValues() {
        return map.values();
    }

    public static List<PartMain> getMains() {
        if (mains == null) {
            mains = (ImmutableList)map.values().stream().filter(p -> p instanceof PartMain).map(PartMain.class::cast).collect(ImmutableList.toImmutableList());
        }
        return mains;
    }

    public static List<PartRod> getRods() {
        if (rods == null) {
            rods = (ImmutableList)map.values().stream().filter(p -> p instanceof PartRod).map(PartRod.class::cast).collect(ImmutableList.toImmutableList());
        }
        return rods;
    }

    public static List<PartMain> getVisibleMains() {
        if (visibleMains == null) {
            visibleMains = (ImmutableList)map.values().stream().filter(p -> p instanceof PartMain && !p.isBlacklisted() && !p.isHidden()).map(PartMain.class::cast).collect(ImmutableList.toImmutableList());
        }
        return visibleMains;
    }

    public static List<PartRod> getVisibleRods() {
        if (visibleRods == null) {
            visibleRods = (ImmutableList)map.values().stream().filter(p -> p instanceof PartRod && !p.isBlacklisted() && !p.isHidden()).map(PartRod.class::cast).collect(ImmutableList.toImmutableList());
        }
        return visibleRods;
    }

    public static void resetVisiblePartCaches() {
        visibleMains = null;
        visibleRods = null;
    }

    public static void getDebugLines(List<String> list) {
        list.add("PartRegistry.map=" + map.size());
        list.add("PartRegistry.STACK_TO_PART=" + STACK_TO_PART.size());
    }

    public static int getHighestMainPartTier() {
        return highestMainPartTier;
    }
}

