/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.PartBinding;
import net.silentchaos512.gear.api.parts.PartBowstring;
import net.silentchaos512.gear.api.parts.PartGrip;
import net.silentchaos512.gear.api.parts.PartHighlight;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartOrigins;
import net.silentchaos512.gear.api.parts.PartRod;
import net.silentchaos512.gear.api.parts.PartTip;
import net.silentchaos512.gear.api.parts.PartUpgrade;

public final class PartType {
    private static final Map<String, PartType> VALUES = new HashMap<String, PartType>();
    public static final PartType BINDING = PartType.create("binding", "b", PartBinding::new);
    public static final PartType BOWSTRING = PartType.create("bowstring", "B", PartBowstring::new);
    public static final PartType GRIP = PartType.create("grip", "G", PartGrip::new);
    public static final PartType HIGHLIGHT = PartType.create("highlight", "h", PartHighlight::new);
    public static final PartType MAIN = PartType.create("main", "M", PartMain::new);
    public static final PartType MISC_UPGRADE = PartType.create("misc_upgrade", "U", PartUpgrade::new);
    public static final PartType ROD = PartType.create("rod", "R", PartRod::new);
    public static final PartType TIP = PartType.create("tip", "T", PartTip::new);
    private final String name;
    private final String debugSymbol;
    private final BiFunction<ResourceLocation, PartOrigins, ItemPart> partConstructor;

    public static PartType create(String name, String debugSymbol, BiFunction<ResourceLocation, PartOrigins, ItemPart> partConstructor) {
        if (VALUES.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Already have PartType \"%s\"", name));
        }
        PartType type = new PartType(name, debugSymbol, partConstructor);
        VALUES.put(name, type);
        return type;
    }

    @Nullable
    public static PartType get(String name) {
        return VALUES.get(name);
    }

    public static Collection<PartType> getValues() {
        return VALUES.values();
    }

    private PartType(String name, String debugSymbol, BiFunction<ResourceLocation, PartOrigins, ItemPart> partConstructor) {
        this.name = name;
        this.debugSymbol = debugSymbol;
        this.partConstructor = partConstructor;
    }

    public ItemPart construct(ResourceLocation registryName, PartOrigins origin) {
        return this.partConstructor.apply(registryName, origin);
    }

    public String toString() {
        return "PartType[" + this.debugSymbol + "]{name='" + this.name + "'}";
    }

    public String getName() {
        return this.name;
    }

    public String getDebugSymbol() {
        return this.debugSymbol;
    }
}

