/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.stats.StatInstance;

@ParametersAreNonnullByDefault
public class ItemStat {
    public static final Map<String, ItemStat> ALL_STATS = new LinkedHashMap<String, ItemStat>();
    protected final ResourceLocation name;
    protected final float defaultValue;
    protected final float minimumValue;
    protected final float maximumValue;
    private boolean isHidden = false;
    private boolean synergyApplies = false;
    private boolean affectedByGrades = true;
    public final boolean displayAsInt;
    public final TextFormatting displayColor;
    private static final float WEIGHT_BASE_MIN = 2.0f;
    private static final float WEIGHT_BASE_MAX = 40.0f;
    private static final float WEIGHT_DEVIATION_COEFF = 2.0f;

    public ItemStat(ResourceLocation name, float defaultValue, float minValue, float maxValue, boolean displayAsInt, TextFormatting displayColor) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.minimumValue = minValue;
        this.maximumValue = maxValue;
        this.displayAsInt = displayAsInt;
        this.displayColor = displayColor;
        if (this.minimumValue > this.maximumValue) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (this.defaultValue < this.minimumValue) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (this.defaultValue > this.maximumValue) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
        ALL_STATS.put(name.func_110623_a(), this);
    }

    private float clampValue(float value) {
        value = MathHelper.func_76131_a((float)value, (float)this.minimumValue, (float)this.maximumValue);
        return value;
    }

    public float compute(float baseValue, Collection<StatInstance> modifiers) {
        return this.compute(baseValue, true, modifiers);
    }

    public float compute(float baseValue, boolean clampValue, Collection<StatInstance> modifiers) {
        if (modifiers.isEmpty()) {
            return baseValue;
        }
        float primaryMod = -1.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.AVG || !(primaryMod < 0.0f)) continue;
            primaryMod = mod.getValue();
        }
        if (primaryMod <= 0.0f) {
            primaryMod = 1.0f;
        }
        float f0 = baseValue;
        int count = 0;
        float totalWeight = 0.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.AVG) continue;
            float weightBase = MathHelper.func_76131_a((float)(2.0f + 2.0f * (mod.getValue() - primaryMod) / primaryMod), (float)2.0f, (float)40.0f);
            float weight = (float)Math.pow(weightBase, -(++count == 0 ? (double)count : 0.5 + (double)(0.5f * (float)count)));
            totalWeight += weight;
            f0 += mod.getValue() * weight;
        }
        if (count > 0) {
            f0 /= totalWeight;
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.ADD) continue;
            f0 += mod.getValue();
        }
        float f1 = f0;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MUL1) continue;
            f1 += f0 * mod.getValue();
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MUL2) continue;
            f1 *= 1.0f + mod.getValue();
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MAX) continue;
            f1 = Math.max(f1, mod.getValue());
        }
        return clampValue ? this.clampValue(f1) : f1;
    }

    public StatInstance computeForDisplay(float baseValue, MaterialGrade grade, Collection<StatInstance> modifiers) {
        if (modifiers.isEmpty()) {
            return new StatInstance("no_mods", baseValue, StatInstance.Operation.AVG);
        }
        boolean add = true;
        for (StatInstance inst : modifiers) {
            StatInstance.Operation op = inst.getOp();
            if (op != StatInstance.Operation.AVG && op != StatInstance.Operation.ADD && op != StatInstance.Operation.MAX) continue;
            add = false;
            break;
        }
        float value = this.compute(baseValue + (float)add, false, modifiers) - (float)add;
        if (this.affectedByGrades) {
            float gradeBonus = 1.0f + (float)grade.bonusPercent / 100.0f;
            value *= gradeBonus;
        }
        StatInstance.Operation op = modifiers.iterator().next().getOp();
        return new StatInstance("display_" + this.name, value, op);
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public ItemStat setHidden(boolean value) {
        this.isHidden = value;
        return this;
    }

    public boolean doesSynergyApply() {
        return this.synergyApplies;
    }

    public ItemStat setSynergyApplies(boolean value) {
        this.synergyApplies = value;
        return this;
    }

    public boolean isAffectedByGrades() {
        return this.affectedByGrades;
    }

    public ItemStat setAffectedByGrades(boolean value) {
        this.affectedByGrades = value;
        return this;
    }

    public String toString() {
        return String.format("ItemStat{%s, default=%.2f, min=%.2f, max=%.2f}", this.name, Float.valueOf(this.defaultValue), Float.valueOf(this.minimumValue), Float.valueOf(this.maximumValue));
    }

    public String translatedName() {
        return SilentGear.i18n.translate("stat." + this.name, new Object[0]);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public float getMinimumValue() {
        return this.minimumValue;
    }

    public float getMaximumValue() {
        return this.maximumValue;
    }
}

