/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.lib.ResourceOrigin;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.lib.util.MathUtils;

public class Trait {
    private static final Gson GSON = new GsonBuilder().create();
    private float activationChance;
    private int maxLevel;
    private ResourceLocation name;
    private TextFormatting nameColor = TextFormatting.GRAY;
    private ResourceOrigin origin = ResourceOrigin.BUILTIN_CORE;
    private final Set<String> cancelsWith = new HashSet<String>();

    public Trait(ResourceLocation name, ResourceOrigin origin) {
        this.name = name;
        this.origin = origin;
        if (!this.origin.validate(this.name, "silentgear")) {
            throw new IllegalArgumentException(String.format("Trait '%s' has origin %s, but should be %s", new Object[]{this.name, this.origin, ResourceOrigin.BUILTIN_ADDON}));
        }
    }

    public Trait(ResourceLocation name, int maxLevel, TextFormatting nameColor, float activationChance) {
        this.name = name;
        this.maxLevel = maxLevel;
        this.nameColor = nameColor;
        this.activationChance = activationChance;
    }

    public static void setCancelsWith(Trait t1, Trait t2) {
        SilentGear.log.debug("Set trait cancels with: '{}' and '{}'", new Object[]{t1.name, t2.name});
        t1.cancelsWith.add(t2.name.toString());
        t2.cancelsWith.add(t1.name.toString());
    }

    public final int getCanceledLevel(int level, Trait other, int otherLevel) {
        if (this.willCancelWith(other)) {
            int diff = level - otherLevel;
            int newLevel = diff < 0 ? MathHelper.func_76125_a((int)diff, (int)(-other.maxLevel), (int)0) : MathHelper.func_76125_a((int)diff, (int)0, (int)this.maxLevel);
            return newLevel;
        }
        return level;
    }

    public final boolean willCancelWith(Trait other) {
        return this.cancelsWith.contains(other.name.toString());
    }

    public String getTranslatedName(int level) {
        String translatedName = SilentGear.i18n.translate("trait." + this.name, new Object[0]);
        String levelString = SilentGear.i18n.translate("enchantment.level." + level, new Object[0]);
        return SilentGear.i18n.translate("trait", "displayFormat", new Object[]{translatedName, levelString});
    }

    public String toString() {
        return "Trait{name=" + this.name + ", origin=" + (Object)((Object)this.origin) + ", maxLevel=" + this.maxLevel + '}';
    }

    public NBTTagCompound writeToNBT(int level) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("Name", this.name.toString());
        tagCompound.func_74774_a("Level", (byte)level);
        return tagCompound;
    }

    private String getResourceFileLocation() {
        return String.format("assets/%s/traits/%s.json", this.name.func_110624_b(), this.name.func_110623_a());
    }

    void loadJsonResources() {
        String path = this.getResourceFileLocation();
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (resourceAsStream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, "UTF-8"));){
                this.readResourceFile(reader);
            }
            catch (Exception e) {
                SilentGear.log.warn("Error reading trait file '{}'", new Object[]{path});
                SilentGear.log.catching((Throwable)e);
            }
        } else if (this.origin.isBuiltin()) {
            SilentGear.log.error("Trait '{}' is missing its data file!", new Object[]{this.name});
        }
        File file = new File(Config.INSTANCE.getDirectory().getPath(), "traits/" + this.name.func_110623_a() + ".json");
        try (BufferedReader reader2 = new BufferedReader(new FileReader(file));){
            this.readResourceFile(reader2);
        }
        catch (FileNotFoundException reader2) {
        }
        catch (Exception e) {
            SilentGear.log.warn("Error reading trait override '{}'", new Object[]{file.getAbsolutePath()});
            SilentGear.log.catching((Throwable)e);
        }
    }

    private void readResourceFile(BufferedReader reader) {
        JsonElement je = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
        JsonObject json = je.getAsJsonObject();
        Loader.processJson(this, json);
        this.processExtraJson(json);
    }

    protected void processExtraJson(JsonObject json) {
    }

    protected boolean shouldActivate(int level, ItemStack gear) {
        if (this.activationChance == 0.0f) {
            return false;
        }
        return MathUtils.tryPercentage((double)(this.activationChance * (float)level));
    }

    public float onAttackEntity(@Nullable EntityPlayer player, EntityLivingBase target, int level, ItemStack gear, float baseValue) {
        return baseValue;
    }

    public float onDurabilityDamage(@Nullable EntityPlayer player, int level, ItemStack gear, int damageTaken) {
        return damageTaken;
    }

    public float onGetStat(@Nullable EntityPlayer player, ItemStat stat, int level, ItemStack gear, float value, float damageRatio) {
        return value;
    }

    public void tick(World world, @Nullable EntityPlayer player, int level, ItemStack gear, boolean isEquipped) {
    }

    public float getActivationChance() {
        return this.activationChance;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public TextFormatting getNameColor() {
        return this.nameColor;
    }

    public ResourceOrigin getOrigin() {
        return this.origin;
    }

    private static class Loader {
        private Loader() {
        }

        private static void processJson(Trait trait, JsonObject json) {
            trait.activationChance = JsonUtils.func_151221_a((JsonObject)json, (String)"activation_chance", (float)trait.activationChance);
            trait.maxLevel = JsonUtils.func_151208_a((JsonObject)json, (String)"max_level", (int)trait.maxLevel);
            if (json.has("name_color")) {
                TextFormatting format = TextFormatting.func_96300_b((String)JsonUtils.func_151200_h((JsonObject)json, (String)"name_color"));
                trait.nameColor = format != null ? format : trait.nameColor;
            }
            Loader.processCancelsWithArray(trait, json);
        }

        private static void processCancelsWithArray(Trait trait, JsonObject json) {
            JsonElement elemCancelsWith;
            if (json.has("cancels_with") && (elemCancelsWith = json.get("cancels_with")).isJsonArray()) {
                trait.cancelsWith.clear();
                for (JsonElement element : elemCancelsWith.getAsJsonArray()) {
                    if (!element.isJsonPrimitive()) continue;
                    String str = element.getAsString();
                    if (!str.contains(":")) {
                        str = "silentgear:" + str;
                    }
                    trait.cancelsWith.add(str);
                }
            }
        }
    }
}

