/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.silentchaos512.gear.api.traits.Trait;

public final class TraitRegistry {
    private static final Map<String, Trait> MAP = new LinkedHashMap<String, Trait>();

    private TraitRegistry() {
        throw new IllegalAccessError("Utility class");
    }

    @Nullable
    public static Trait get(String key) {
        return MAP.get(key);
    }

    public static <T extends Trait> T register(T trait) {
        String key = trait.getName().toString();
        if (MAP.containsKey(key)) {
            throw new IllegalArgumentException("Already have a trait with key " + key);
        }
        MAP.put(key, trait);
        trait.loadJsonResources();
        return trait;
    }
}

