/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.world.feature.NetherwoodTree;
import net.silentchaos512.lib.util.MathUtils;

public class NetherwoodSapling
extends BlockBush
implements IGrowable {
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);

    public NetherwoodSapling() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        Block blockBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return state.func_177230_c() == this && blockBelow == Blocks.field_150424_aL || super.func_180671_f(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        Block target = worldIn.func_180495_p(pos).func_177230_c();
        return target.func_176200_f((IBlockAccess)worldIn, pos) && (soil.func_177230_c() == Blocks.field_150424_aL || soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) || super.func_176196_c(worldIn, pos);
    }

    private static void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        new NetherwoodTree(ModBlocks.netherwoodLog.func_176223_P(), ModBlocks.netherwoodLeaves.func_176223_P()).func_180709_b(worldIn, rand, pos);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockSapling.field_176479_b});
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return MathUtils.tryPercentage((double)0.45);
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        NetherwoodSapling.grow(worldIn, pos, state, rand);
    }

    private static void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)BlockSapling.field_176479_b), 4);
        } else {
            NetherwoodSapling.generateTree(worldIn, pos, state, rand);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            int darkness = 15 - worldIn.func_175671_l(pos.func_177984_a());
            if (worldIn.func_175697_a(pos, 1) && rand.nextInt(5 + darkness / 2) == 0) {
                NetherwoodSapling.grow(worldIn, pos, state, rand);
            }
        }
    }
}

