/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.analyzer;

import java.util.stream.IntStream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.tile.TileSidedInventorySL;
import net.silentchaos512.lib.util.TimeHelper;

public class TilePartAnalyzer
extends TileSidedInventorySL
implements ITickable {
    static final int BASE_ANALYZE_TIME = TimeHelper.ticksFromSeconds((float)5.0f);
    static final int INPUT_SLOT = 0;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = IntStream.rangeClosed(1, 4).toArray();
    static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    @SyncVariable(name="progress")
    int progress = 0;
    private boolean requireClientSync = false;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack input = this.getInputStack();
        ItemPart part = PartRegistry.get(input);
        if (part != null) {
            int outputSlot;
            if (this.progress < BASE_ANALYZE_TIME) {
                ++this.progress;
                this.requireClientSync = true;
            }
            if (this.progress >= BASE_ANALYZE_TIME && (outputSlot = this.getFreeOutputSlot()) > 0) {
                this.progress = 0;
                ItemStack stack = input.func_77946_l();
                stack.func_190920_e(1);
                input.func_190918_g(1);
                MaterialGrade.selectRandom(SilentGear.random).setGradeOnStack(stack);
                this.func_70299_a(outputSlot, stack);
                if (input.func_190916_E() <= 0) {
                    for (int slot : SLOTS_INPUT) {
                        if (!this.func_70301_a(slot).func_190926_b()) continue;
                        this.func_70299_a(slot, ItemStack.field_190927_a);
                    }
                }
                this.requireClientSync = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.requireClientSync) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.requireClientSync = false;
        }
    }

    public int func_70302_i_() {
        return INVENTORY_SIZE;
    }

    private ItemStack getInputStack() {
        for (int slot : SLOTS_INPUT) {
            ItemStack stack = this.func_70301_a(slot);
            if (!(PartRegistry.get(stack) instanceof PartMain) || MaterialGrade.fromStack(stack) != MaterialGrade.NONE) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.func_70301_a(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
            }
        }
    }

    public int func_174890_g() {
        return 1;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tags = new NBTTagCompound();
        this.writeSyncVars(tags, SyncVariable.Type.PACKET);
        ItemStack input = this.getInputStack();
        if (!input.func_190926_b()) {
            NBTTagCompound itemTags = input.func_77955_b(new NBTTagCompound());
            tags.func_74782_a("input_item", (NBTBase)itemTags);
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tags);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        this.writeSyncVars(tags, SyncVariable.Type.PACKET);
        NBTTagList tagList = new NBTTagList();
        ItemStack input = this.getInputStack();
        if (!input.func_190926_b()) {
            NBTTagCompound itemTags = new NBTTagCompound();
            itemTags.func_74774_a("Slot", (byte)0);
            input.func_77955_b(itemTags);
            tagList.func_74742_a((NBTBase)itemTags);
        }
        tags.func_74782_a("Items", (NBTBase)tagList);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound tags = packet.func_148857_g();
        this.readSyncVars(tags);
        if (tags.func_74764_b("input_item")) {
            this.func_70299_a(0, new ItemStack(tags.func_74775_l("input_item")));
        } else {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return (int[])SLOTS_OUTPUT.clone();
            }
        }
        return (int[])SLOTS_INPUT.clone();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index != 0 || stack.func_190926_b() || !this.func_70301_a(index).func_190926_b() && !this.func_70301_a(index).func_77969_a(stack)) {
            return false;
        }
        MaterialGrade grade = MaterialGrade.fromStack(stack);
        if (grade != MaterialGrade.NONE) {
            return false;
        }
        return PartRegistry.get(stack) instanceof PartMain;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 0;
    }
}

