/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.craftingstation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.block.craftingstation.TileCraftingStation;
import net.silentchaos512.gear.crafting.recipe.RecipeModularItem;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.inventory.InventoryCraftingStation;
import net.silentchaos512.gear.inventory.SlotCraftingStationOutput;
import net.silentchaos512.gear.inventory.SlotItemPart;
import net.silentchaos512.gear.item.ToolHead;

public class ContainerCraftingStation
extends Container {
    InventoryCrafting craftMatrix;
    InventoryCraftResult craftResult;
    private Slot outputSlot;
    private final EntityPlayer player;
    private final TileCraftingStation tile;
    private final World world;

    public ContainerCraftingStation(InventoryPlayer playerInventory, World worldIn, BlockPos posIn, TileCraftingStation tile) {
        this.player = playerInventory.field_70458_d;
        this.tile = tile;
        this.world = this.tile.func_145831_w();
        this.craftMatrix = new InventoryCraftingStation(this, tile, 3, 3);
        this.craftResult = new InventoryCraftResult();
        this.setupInventorySlots(playerInventory, (IInventory)this.tile);
    }

    private void setupInventorySlots(InventoryPlayer playerInv, IInventory extendedInv) {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.setupCraftingGrid();
        this.setupPartSlots();
        this.setupSideInventory();
        this.setupPlayerSlots(playerInv);
        this.outputSlot = this.func_75146_a((Slot)new SlotCraftingStationOutput(this, playerInv.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, (IInventory)this.tile, this.tile.func_70302_i_(), 146, 35));
        this.func_75130_a((IInventory)this.tile);
    }

    private void setupCraftingGrid() {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = x + y * 3;
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, index, 8 + x * 18, 17 + y * 18));
            }
        }
    }

    private void setupPartSlots() {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 2; ++x) {
                int index = 9 + x + y * 2;
                this.func_75146_a(new SlotItemPart(this, (IInventory)this.tile, index, 79 + x * 18, 17 + y * 18));
            }
        }
    }

    private void setupPlayerSlots(InventoryPlayer playerInventory) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = x + (y + 1) * 9;
                this.func_75146_a(new Slot((IInventory)playerInventory, index, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 142));
        }
    }

    private void setupSideInventory() {
        int rowCount = (int)Math.ceil(6.0);
        int totalHeight = 44 + 18 * (rowCount - 2);
        for (int y = 0; y < rowCount; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 15 + x + y * 3;
                int xPos = x * 18 - 56;
                int yPos = y * 18 + 5 + (166 - totalHeight) / 2;
                this.func_75146_a(new Slot((IInventory)this.tile, index, xPos, yPos));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.func_70300_a(playerIn);
    }

    public Slot func_75139_a(int slotId) {
        return slotId == this.outputSlot.getSlotIndex() ? this.outputSlot : super.func_75139_a(slotId);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.craftMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.tile.func_70299_a(i + 0, stack);
        }
        this.tile.func_70296_d();
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (this.craftMatrix != null && this.craftResult != null) {
            this.func_192389_a(this.world, this.player, this.craftMatrix, this.craftResult);
            super.func_75130_a(inventoryIn);
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int playerStart = this.tile.func_70302_i_();
            int hotbarStart = playerStart + 27;
            if (slot == this.outputSlot) {
                itemstack1.func_77973_b().func_77622_d(itemstack1, this.world, playerIn);
                if (!this.func_75135_a(itemstack1, playerStart, playerStart + 36, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= playerStart && index < hotbarStart ? !this.func_75135_a(itemstack1, 9, 15, false) && !this.func_75135_a(itemstack1, 15, 33, false) && !this.func_75135_a(itemstack1, hotbarStart, hotbarStart + 9, false) : (index >= hotbarStart && index < hotbarStart + 9 ? !this.func_75135_a(itemstack1, 9, 15, false) && !this.func_75135_a(itemstack1, 15, 33, false) && !this.func_75135_a(itemstack1, playerStart, playerStart + 27, false) : !this.func_75135_a(itemstack1, playerStart, playerStart + 36, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting craftMatrix, InventoryCraftResult craftResult) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
        ItemStack itemstack = ItemStack.field_190927_a;
        IRecipe irecipe = CraftingManager.func_192413_b((InventoryCrafting)craftMatrix, (World)world);
        if (irecipe != null && (irecipe.func_192399_d() || !world.func_82736_K().func_82766_b("doLimitedCrafting") || entityplayermp.func_192037_E().func_193830_f(irecipe))) {
            craftResult.func_193056_a(irecipe);
            itemstack = irecipe.func_77572_b(craftMatrix);
            if (itemstack.func_77973_b() instanceof ToolHead) {
                String toolClass = ToolHead.getToolClass(itemstack);
                RecipeModularItem recipe = ModRecipes.gearCrafting.get(toolClass);
                ICoreItem item = ModItems.gearClasses.get(toolClass);
                if (recipe != null && item != null) {
                    NonNullList partStackList = NonNullList.func_191196_a();
                    partStackList.add((Object)itemstack.func_77946_l());
                    Map<ItemPartData, Integer> partList = this.getCompatibleParts(item);
                    Set partTypesFound = partList.keySet().stream().map(p -> p.getPart().getType()).collect(Collectors.toSet());
                    partTypesFound.add(PartType.MAIN);
                    boolean allRequiredPartsFound = true;
                    for (PartType type : item.getConfig().getRequiredPartTypes()) {
                        if (partTypesFound.contains(type)) continue;
                        allRequiredPartsFound = false;
                        break;
                    }
                    if (allRequiredPartsFound) {
                        partStackList.addAll((Collection)partList.keySet().stream().map(ItemPartData::getCraftingItem).collect(Collectors.toList()));
                        ItemStack result = recipe.getCraftingResult((Collection<ItemStack>)partStackList);
                        if (!result.func_190926_b()) {
                            itemstack = result;
                        }
                    }
                }
            }
        }
        int index = this.outputSlot.getSlotIndex();
        craftResult.func_70299_a(index, itemstack);
        entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, index, itemstack));
    }

    public Map<ItemPartData, Integer> getCompatibleParts(ICoreItem item) {
        HashMap<ItemPartData, Integer> result = new HashMap<ItemPartData, Integer>();
        HashSet<PartType> typesFound = new HashSet<PartType>();
        for (int i = 9; i < 15; ++i) {
            boolean incompatible;
            ItemStack partStack = this.func_75139_a(i).func_75211_c();
            ItemPartData part = ItemPartData.fromStack(partStack);
            if (part == null) continue;
            PartType type = part.getPart().getType();
            int requiredCount = item.getConfig().getCraftingPartCount(type);
            boolean isMiscUpgrade = type == PartType.MISC_UPGRADE;
            boolean enoughInStack = requiredCount <= partStack.func_190916_E();
            boolean roomForPart = !typesFound.contains(type) || isMiscUpgrade;
            boolean bl = incompatible = requiredCount == 0 && !(part.getPart() instanceof IUpgradePart);
            if (!enoughInStack || !roomForPart || incompatible) continue;
            result.put(part, Math.max(1, requiredCount));
            if (isMiscUpgrade) continue;
            typesFound.add(type);
        }
        return result;
    }
}

