/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.craftingstation;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.block.craftingstation.ContainerCraftingStation;
import net.silentchaos512.gear.block.craftingstation.TileCraftingStation;
import net.silentchaos512.gear.client.gui.GuiItemParts;
import net.silentchaos512.gear.client.util.TooltipFlagTC;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.item.ToolHead;
import net.silentchaos512.lib.client.key.KeyTrackerSL;
import net.silentchaos512.lib.gui.TexturedButton;
import net.silentchaos512.lib.util.StringUtil;

public class GuiCraftingStation
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("silentgear", "textures/gui/crafting_station.png");
    private final TileCraftingStation tile;
    private final ContainerCraftingStation container;
    private TexturedButton buttonShowAllParts;

    public GuiCraftingStation(TileCraftingStation tile, ContainerCraftingStation inventorySlotsIn) {
        super((Container)inventorySlotsIn);
        this.tile = tile;
        this.container = inventorySlotsIn;
        this.field_146999_f = 256;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonShowAllParts = new TexturedButton(TEXTURE, 100, this.field_147003_i + 149, this.field_147009_r + 5, 236, 166, 20, 18, (List)ImmutableList.of((Object)"Show Available Parts", (Object)(TextFormatting.GRAY + "List can be sorted by stats")));
        this.field_146292_n.add(this.buttonShowAllParts);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.buttonShowAllParts) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiItemParts());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.buttonShowAllParts.func_146115_a()) {
            this.buttonShowAllParts.drawHover(mouseX, mouseY);
        }
    }

    private TooltipFlagTC getTooltipFlag(ItemStack stack) {
        boolean ctrl = stack.func_77973_b() instanceof ICoreItem || stack.func_77973_b() instanceof ToolHead;
        boolean alt = KeyTrackerSL.isAltDown();
        boolean shift = KeyTrackerSL.isShiftDown();
        return new TooltipFlagTC(ctrl, alt, shift, false);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(SilentGear.i18n.subText((IForgeRegistryEntry)ModBlocks.craftingStation, "crafting", new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(SilentGear.i18n.subText((IForgeRegistryEntry)ModBlocks.craftingStation, "parts", new Object[0]), 80, 6, 0x404040);
        this.field_146289_q.func_78276_b(SilentGear.i18n.subText((IForgeRegistryEntry)ModBlocks.craftingStation, "storage", new Object[0]), -55, 19, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        String versionNumString = "Version: 0.5.2-63" + (SilentGear.instance.isDevBuild() ? " (dev)" : "");
        int versionNumStringWidth = this.field_146289_q.func_78256_a(versionNumString);
        float versionNumScale = 0.65f;
        StringUtil.renderScaledAsciiString((FontRenderer)this.field_146289_q, (String)versionNumString, (int)((int)((float)this.field_146999_f - (float)versionNumStringWidth * versionNumScale) - 1), (int)(this.field_147000_g + 1), (int)0xCCCCCC, (boolean)false, (float)versionNumScale);
        ItemStack craftResult = this.container.craftResult.func_70301_a(0);
        this.drawSlimeFace(craftResult);
        if (!craftResult.func_190926_b()) {
            FontRenderer font = this.field_146297_k.field_71466_p;
            List tooltip = craftResult.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)this.getTooltipFlag(craftResult));
            int maxWidth = 0;
            for (String line : tooltip) {
                maxWidth = Math.max(maxWidth, font.func_78256_a(line));
            }
            float scale = 75.0f / (float)maxWidth;
            int xPos = (int)((float)(this.field_146999_f - 82) / scale);
            int yPos = (int)((float)(this.field_147000_g - 160) / scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            int step = (int)(scale * 10.0f);
            for (String line : tooltip) {
                font.func_175063_a(line, (float)xPos, (float)yPos, 0xFFFFFF);
                yPos += Math.round((float)step / scale);
            }
            GlStateManager.func_179121_F();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
        int rowCount = 6;
        int rowWidth = 62;
        int totalHeight = 116;
        int x = xPos - 61;
        int y = yPos + (this.field_147000_g - 116) / 2;
        for (int i = 0; i < 6; ++i) {
            int height;
            int n = height = i == 0 || i == 5 ? 22 : 18;
            int ty = 194 + (i == 0 ? 0 : (i == 5 ? 40 : 22));
            this.func_73729_b(x, y, 0, ty, 62, height);
            y += height;
        }
        this.func_73729_b(x, y - 116 - 12, 0, 177, 62, 15);
        x = xPos + 171;
        y = yPos + 4;
        GuiCraftingStation.func_73734_a((int)x, (int)y, (int)(x + 80), (int)(y + 158), (int)-822083584);
    }

    private void drawSlimeFace(ItemStack craftResult) {
        ResourceLocation name;
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textureY = 245;
        int textureX = craftResult.func_190926_b() ? (this.container.craftMatrix.func_191420_l() ? 223 : 234) : ((name = craftResult.func_77973_b().getRegistryName()) == null || "tconstruct".equals(name.func_110624_b()) ? 245 : 212);
        this.func_73729_b(this.field_146999_f - 18, this.field_147000_g - 17, textureX, 245, 11, 11);
        this.field_146297_k.func_110434_K().func_110577_a(field_110324_m);
    }
}

