/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.craftingstation;

import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.lib.tile.TileInventorySL;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TileCraftingStation
extends TileInventorySL {
    public static final int CRAFTING_GRID_SIZE = 9;
    public static final int GEAR_PARTS_SIZE = 6;
    public static final int SIDE_INVENTORY_SIZE = 18;
    public static final int CRAFTING_GRID_START = 0;
    public static final int GEAR_PARTS_START = 9;
    public static final int SIDE_INVENTORY_START = 15;
    private static final int CURRENT_VERSION = 1;
    private static final String NBT_VERSION = "SGCS_Version";

    public NonNullList<Pair<ItemStack, IInventory>> getAdjacentInventories() {
        NonNullList list = NonNullList.func_191196_a();
        for (EnumFacing side : Arrays.asList(null, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST)) {
            BlockPos pos = side == null ? this.field_174879_c : this.field_174879_c.func_177972_a(side);
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (!(te instanceof IInventory)) continue;
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            RayTraceResult raytrace = new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), side, pos);
            ItemStack stack = state.func_177230_c().getPickBlock(state, raytrace, this.field_145850_b, pos, null);
            list.add((Object)new ImmutablePair((Object)stack, (Object)((IInventory)te)));
        }
        return list;
    }

    public IInventory getInternalStorage() {
        return this;
    }

    public String func_70005_c_() {
        return "crafting_station";
    }

    public int func_70302_i_() {
        return 33;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.handleVersionUpdates(tags.func_74771_c(NBT_VERSION));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74774_a(NBT_VERSION, (byte)1);
        return super.func_189515_b(tags);
    }

    private void handleVersionUpdates(int previousVersion) {
        if (previousVersion != 1) {
            SilentGear.log.info("Crafting Station at {} is updating from version '{}' to '{}'. This should not result in item loss.", new Object[]{this.field_174879_c, previousVersion, 1});
        }
        if (previousVersion == 0) {
            for (int i = 18; i >= 0; --i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.func_70299_a(i + 15, stack);
                this.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }
}

