/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.salvager;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.block.salvager.VanillaGearSalvage;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.config.ConfigOptionEquipment;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.tile.TileSidedInventorySL;
import net.silentchaos512.lib.util.GameUtil;
import net.silentchaos512.lib.util.MathUtils;
import net.silentchaos512.lib.util.TimeHelper;

public class TileSalvager
extends TileSidedInventorySL
implements ITickable {
    static final int BASE_WORK_TIME = TimeHelper.ticksFromSeconds((float)(GameUtil.isDeobfuscated() ? 2.0f : 10.0f));
    private static final int INPUT_SLOT = 0;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = IntStream.rangeClosed(1, 18).toArray();
    private static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    @SyncVariable(name="progress")
    int progress = 0;

    public int func_70302_i_() {
        return INVENTORY_SIZE;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean requiresClientSync = false;
        ItemStack input = this.getInputStack();
        if (!input.func_190926_b()) {
            if (this.progress < BASE_WORK_TIME) {
                ++this.progress;
                requiresClientSync = true;
            }
            if (this.progress >= BASE_WORK_TIME && this.areAllOutputSlotsFree()) {
                for (ItemStack stack : this.getSalvagedPartsWithChance(input)) {
                    int slot = this.getFreeOutputSlot();
                    if (slot > 0) {
                        this.func_70299_a(slot, stack);
                        continue;
                    }
                    SilentGear.log.warn("Item lost in salvager: " + stack, new Object[0]);
                }
                this.progress = 0;
                input.func_190918_g(1);
                requiresClientSync = true;
            }
        }
        if (requiresClientSync) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private boolean canSalvage(ItemStack stack) {
        return stack.func_77973_b() instanceof ICoreItem || VanillaGearSalvage.isVanillaGear(stack);
    }

    private Collection<ItemStack> getSalvagedPartsWithChance(ItemStack stack) {
        double lossRate = this.getLossRate(stack);
        SilentGear.log.debug("Loss rate for '{}': {}", new Object[]{stack, lossRate});
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack part : this.getSalvageableParts(stack)) {
            ItemStack copy = part.func_77946_l();
            int count = copy.func_190916_E();
            for (int i = 0; i < count; ++i) {
                if (!MathUtils.tryPercentage((Random)SilentGear.random, (double)lossRate)) continue;
                copy.func_190918_g(1);
            }
            if (copy.func_190926_b()) continue;
            builder.add((Object)copy);
        }
        return builder.build();
    }

    private double getLossRate(ItemStack stack) {
        int maxDamage = stack.func_77958_k();
        if (maxDamage == 0) {
            return Config.salvagerMinLossRate;
        }
        double ratio = (double)stack.func_77952_i() / (double)maxDamage;
        return Config.salvagerMinLossRate + ratio * (Config.salvagerMaxLossRate - Config.salvagerMinLossRate);
    }

    private Collection<ItemStack> getSalvageableParts(ItemStack stack) {
        if (stack.func_77973_b() instanceof ICoreItem) {
            return TileSalvager.getSalvageFromGearItem(stack);
        }
        if (VanillaGearSalvage.isVanillaGear(stack)) {
            return TileSalvager.getSalvageFromVanillaItem(stack);
        }
        return ImmutableList.of();
    }

    private static Collection<ItemStack> getSalvageFromGearItem(ItemStack stack) {
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        ConfigOptionEquipment config = item.getConfig();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemPartData part : GearData.getConstructionParts(stack)) {
            if (part.isRod()) {
                ItemStack rod = part.getCraftingItem().func_77946_l();
                rod.func_190920_e(Math.max(1, config.getRodCount()));
                builder.add((Object)rod);
                continue;
            }
            if (part.isMain()) {
                ItemStack craftingItem = part.getCraftingItem().func_77946_l();
                part.getGrade().setGradeOnStack(craftingItem);
                builder.add((Object)craftingItem);
                continue;
            }
            builder.add((Object)part.getCraftingItem().func_77946_l());
        }
        return builder.build();
    }

    private static Collection<ItemStack> getSalvageFromVanillaItem(ItemStack stack) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Item headItem = VanillaGearSalvage.getHeadItem(stack);
        int headCount = VanillaGearSalvage.getHeadCount(stack);
        if (headItem != null && headCount > 0) {
            builder.add((Object)new ItemStack(headItem, headCount));
        }
        Item rodItem = Items.field_151055_y;
        int rodCount = VanillaGearSalvage.getRodCount(stack);
        if (rodCount > 0) {
            builder.add((Object)new ItemStack(rodItem, rodCount));
        }
        return builder.build();
    }

    private ItemStack getInputStack() {
        for (int slot : SLOTS_INPUT) {
            ItemStack stack = this.func_70301_a(slot);
            if (!this.canSalvage(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.func_70301_a(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    private boolean areAllOutputSlotsFree() {
        for (int slot : SLOTS_OUTPUT) {
            if (this.func_70301_a(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
            }
        }
    }

    public int func_174890_g() {
        return 1;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        this.writeSyncVars(tags, SyncVariable.Type.PACKET);
        return tags;
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return (int[])SLOTS_OUTPUT.clone();
            }
        }
        return (int[])SLOTS_INPUT.clone();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_190926_b() || TileSalvager.isOutputSlot(index)) {
            return false;
        }
        ItemStack current = this.func_70301_a(index);
        if (!current.func_190926_b() && !current.func_77969_a(stack)) {
            return false;
        }
        if (TileSalvager.isInputSlot(index)) {
            return this.canSalvage(stack);
        }
        return super.func_94041_b(index, stack);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return TileSalvager.isOutputSlot(index);
    }

    private static boolean isInputSlot(int index) {
        for (int k : SLOTS_INPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }

    private static boolean isOutputSlot(int index) {
        for (int k : SLOTS_OUTPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }
}

