/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.salvager;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.silentchaos512.gear.SilentGear;

final class VanillaGearSalvage {
    private static final Collection<Item> items = ImmutableList.of((Object)Items.field_151048_u, (Object)Items.field_151010_B, (Object)Items.field_151040_l, (Object)Items.field_151052_q, (Object)Items.field_151041_m, (Object)Items.field_151046_w, (Object)Items.field_151005_D, (Object)Items.field_151035_b, (Object)Items.field_151050_s, (Object)Items.field_151039_o, (Object)Items.field_151047_v, (Object)Items.field_151011_C, (Object[])new Item[]{Items.field_151037_a, Items.field_151051_r, Items.field_151038_n, Items.field_151056_x, Items.field_151006_E, Items.field_151036_c, Items.field_151049_t, Items.field_151053_p, Items.field_151012_L, Items.field_151013_M, Items.field_151019_K, Items.field_151018_J, Items.field_151017_I, Items.field_151021_T, Items.field_151027_R, Items.field_151024_Q, Items.field_151026_S, Items.field_151029_X, Items.field_151023_V, Items.field_151020_U, Items.field_151022_W, Items.field_151167_ab, Items.field_151030_Z, Items.field_151028_Y, Items.field_151165_aa, Items.field_151151_aj, Items.field_151171_ah, Items.field_151169_ag, Items.field_151149_ai, Items.field_151175_af, Items.field_151163_ad, Items.field_151161_ac, Items.field_151173_ae});

    private VanillaGearSalvage() {
    }

    static boolean isVanillaGear(ItemStack stack) {
        return items.contains(stack.func_77973_b());
    }

    static int getHeadCount(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemSpade) {
            return 1;
        }
        if (item instanceof ItemSword || item instanceof ItemHoe) {
            return 2;
        }
        if (item instanceof ItemPickaxe || item instanceof ItemAxe) {
            return 3;
        }
        if (item instanceof ItemArmor) {
            int multi = Objects.requireNonNull(item.getRegistryName()).func_110623_a().startsWith("chainmail") ? 4 : 1;
            EntityEquipmentSlot type = ((ItemArmor)item).field_77881_a;
            if (type == EntityEquipmentSlot.CHEST) {
                return 8 * multi;
            }
            if (type == EntityEquipmentSlot.FEET) {
                return 4 * multi;
            }
            if (type == EntityEquipmentSlot.HEAD) {
                return 5 * multi;
            }
            if (type == EntityEquipmentSlot.LEGS) {
                return 7 * multi;
            }
        }
        SilentGear.log.warn("Tried to salvage '{}' as vanilla gear, but could not identify item type", new Object[]{stack});
        return 0;
    }

    static int getRodCount(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemArmor) {
            return 0;
        }
        if (stack.func_77973_b() instanceof ItemSword) {
            return 1;
        }
        return 2;
    }

    @Nullable
    static Item getHeadItem(ItemStack stack) {
        String name = Objects.requireNonNull(stack.func_77973_b().getRegistryName()).func_110623_a();
        if (name.startsWith("diamond")) {
            return Items.field_151045_i;
        }
        if (name.startsWith("golden")) {
            return Items.field_151043_k;
        }
        if (name.startsWith("iron")) {
            return Items.field_151042_j;
        }
        if (name.startsWith("stone")) {
            return Item.func_150898_a((Block)Blocks.field_150347_e);
        }
        if (name.startsWith("wooden")) {
            return Item.func_150898_a((Block)Blocks.field_150344_f);
        }
        if (name.startsWith("leather")) {
            return Items.field_151116_aA;
        }
        if (name.startsWith("chainmail")) {
            return Items.field_191525_da;
        }
        SilentGear.log.warn("Don't know salvage head part for vanilla gear '{}'", new Object[]{stack});
        return null;
    }
}

