/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.event;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ExtraBlockBreakHandler
implements IResourceManagerReloadListener {
    public static final ExtraBlockBreakHandler INSTANCE = new ExtraBlockBreakHandler(Minecraft.func_71410_x());
    private final Map<Integer, DestroyExtraBlocksProgress> extraDamagedBlocks = new HashMap<Integer, DestroyExtraBlocksProgress>();
    private Minecraft mc;
    private final TextureManager renderEngine;
    private final TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];

    private ExtraBlockBreakHandler(Minecraft mcIn) {
        this.mc = mcIn;
        this.renderEngine = mcIn.func_110434_K();
        ((IReloadableResourceManager)this.mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    @SubscribeEvent
    public void renderBlockBreakAnim(RenderWorldLastEvent event) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        this.drawBlockDamageTexture(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), this.mc.func_175606_aa(), event.getPartialTicks());
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179084_k();
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        this.extraDamagedBlocks.clear();
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        this.extraDamagedBlocks.clear();
    }

    private void preRenderDamagedBlocks() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
    }

    private void postRenderDamagedBlocks() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private void drawBlockDamageTexture(Tessellator tessellatorIn, BufferBuilder bufferBuilderIn, Entity entityIn, float partialTicks) {
        double d3 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d4 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d5 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        if (this.mc.field_71441_e.func_72820_D() % 20L == 0L) {
            this.cleanupExtraDamagedBlocks();
        }
        if (!this.extraDamagedBlocks.isEmpty()) {
            this.renderEngine.func_110577_a(TextureMap.field_110575_b);
            this.preRenderDamagedBlocks();
            bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            bufferBuilderIn.func_178969_c(-d3, -d4, -d5);
            bufferBuilderIn.func_78914_f();
            for (Map.Entry<Integer, DestroyExtraBlocksProgress> entry : this.extraDamagedBlocks.entrySet()) {
                DestroyExtraBlocksProgress destroyblockprogress = entry.getValue();
                BlockPos[] blockpositions = destroyblockprogress.getPositions();
                for (int i = 0; i < blockpositions.length; ++i) {
                    boolean hasBreak;
                    BlockPos blockpos = blockpositions[i];
                    double d6 = (double)blockpos.func_177958_n() - d3;
                    double d7 = (double)blockpos.func_177956_o() - d4;
                    double d8 = (double)blockpos.func_177952_p() - d5;
                    Block block = this.mc.field_71441_e.func_180495_p(blockpos).func_177230_c();
                    TileEntity te = this.mc.field_71441_e.func_175625_s(blockpos);
                    boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
                    if (!hasBreak) {
                        boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
                    }
                    if (hasBreak) continue;
                    if (d6 * d6 + d7 * d7 + d8 * d8 > 16384.0) {
                        this.extraDamagedBlocks.remove(entry.getKey());
                        continue;
                    }
                    IBlockState iblockstate = this.mc.field_71441_e.func_180495_p(blockpos);
                    if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                    int k1 = destroyblockprogress.getPartialBlockDamage();
                    TextureAtlasSprite textureatlassprite = this.destroyBlockIcons[k1];
                    BlockRendererDispatcher blockrendererdispatcher = this.mc.func_175602_ab();
                    blockrendererdispatcher.func_175020_a(iblockstate, blockpos, textureatlassprite, (IBlockAccess)this.mc.field_71441_e);
                }
            }
            tessellatorIn.func_78381_a();
            bufferBuilderIn.func_178969_c(0.0, 0.0, 0.0);
            this.postRenderDamagedBlocks();
        }
    }

    private void cleanupExtraDamagedBlocks() {
        for (Map.Entry<Integer, DestroyExtraBlocksProgress> entry : this.extraDamagedBlocks.entrySet()) {
            DestroyExtraBlocksProgress destroyblockprogress = entry.getValue();
            int k1 = destroyblockprogress.getCreationWorldTick();
            if (this.mc.field_71441_e.func_72820_D() - (long)k1 <= 400L) continue;
            this.extraDamagedBlocks.remove(entry.getKey());
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        TextureMap texturemap = this.mc.func_147117_R();
        for (int i = 0; i < this.destroyBlockIcons.length; ++i) {
            this.destroyBlockIcons[i] = texturemap.func_110572_b("minecraft:blocks/destroy_stage_" + i);
        }
    }

    public void sendBlockBreakProgress(int breakerId, BlockPos[] positions, int progress) {
        if (positions.length > 0 && progress >= 0 && progress < 10) {
            DestroyExtraBlocksProgress destroyextrablocksprogress = new DestroyExtraBlocksProgress(breakerId, positions);
            this.extraDamagedBlocks.put(breakerId, destroyextrablocksprogress);
            destroyextrablocksprogress.setPartialBlockDamage(progress);
            destroyextrablocksprogress.setWorldTick((int)this.mc.field_71441_e.func_72820_D());
        } else {
            this.extraDamagedBlocks.remove(breakerId);
        }
    }

    private static class DestroyExtraBlocksProgress {
        private final int miningPlayerEntId;
        private final BlockPos[] positions;
        private int partialBlockProgress;
        private int createdAtWorldTick;

        public DestroyExtraBlocksProgress(int miningPlayerEntIdIn, BlockPos ... positionsIn) {
            this.miningPlayerEntId = miningPlayerEntIdIn;
            this.positions = positionsIn;
        }

        public BlockPos[] getPositions() {
            return this.positions;
        }

        public void setPartialBlockDamage(int damage) {
            if (damage > 10) {
                damage = 10;
            }
            this.partialBlockProgress = damage;
        }

        public int getPartialBlockDamage() {
            return this.partialBlockProgress;
        }

        public void setWorldTick(int createdAtWorldTickIn) {
            this.createdAtWorldTick = createdAtWorldTickIn;
        }

        public int getCreationWorldTick() {
            return this.createdAtWorldTick;
        }
    }
}

