/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.event;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.Trait;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.lib.client.key.KeyTrackerSL;

@Mod.EventBusSubscriber(modid="silentgear", value={Side.CLIENT})
public final class TooltipHandler {
    private static final boolean TRAIT_DISPLAY_CYCLE = false;
    private static final Pattern REGEX_TRIM_TO_INT = Pattern.compile("\\.0+$");
    private static final Pattern REGEX_REMOVE_TRAILING_ZEROS = Pattern.compile("0+$");

    private TooltipHandler() {
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemPart part;
        LoaderState state = Loader.instance().getLoaderState();
        if (state == LoaderState.INITIALIZATION || state == LoaderState.SERVER_ABOUT_TO_START || state == LoaderState.SERVER_STOPPING) {
            return;
        }
        ItemStack stack = event.getItemStack();
        ItemPart itemPart = part = !stack.func_190926_b() ? PartRegistry.get(stack) : null;
        if (part != null && !part.isBlacklisted(stack)) {
            TooltipHandler.onPartTooltip(event, stack, ItemPartData.instance(part));
            return;
        }
        ResourceLocation name = stack.func_77973_b().getRegistryName();
        if (name != null && Config.nerfedGear.contains(name.toString())) {
            event.getToolTip().add(1, TextFormatting.RED + SilentGear.i18n.translate("misc", "poorlyMade", new Object[0]));
        }
    }

    private static void onPartTooltip(ItemTooltipEvent event, ItemStack stack, ItemPartData partData) {
        ItemPart part = partData.getPart();
        event.getToolTip().add(TextFormatting.GREEN + SilentGear.i18n.translate("part", "type." + part.getType().getName(), new Object[]{part.getTier()}));
        Map<Trait, Integer> traits = partData.getTraits();
        int numTraits = traits.size();
        int traitIndex = TooltipHandler.getTraitDisplayIndex(numTraits);
        int i = 0;
        for (Trait trait : traits.keySet()) {
            if (traitIndex < 0 || traitIndex == i) {
                int level = traits.get(trait);
                TextFormatting nameColor = trait.getNameColor();
                event.getToolTip().add(nameColor + trait.getTranslatedName(level));
            }
            ++i;
        }
        MaterialGrade grade = MaterialGrade.fromStack(stack);
        if (KeyTrackerSL.isControlDown()) {
            if (part instanceof PartMain) {
                TooltipHandler.getGradeLine(event, grade);
            }
            event.getToolTip().add(TextFormatting.GOLD + SilentGear.i18n.translate("misc", "tooltip.stats.name", new Object[0]) + TextFormatting.RESET + TextFormatting.ITALIC + " (Silent Gear)");
            TooltipHandler.getPartStatLines(event, stack, part);
        } else {
            if (grade != MaterialGrade.NONE && part instanceof PartMain) {
                TooltipHandler.getGradeLine(event, grade);
            }
            event.getToolTip().add(TextFormatting.GOLD + SilentGear.i18n.translate("misc", "tooltip.ctrlForStats", new Object[0]));
        }
    }

    private static int getTraitDisplayIndex(int numTraits) {
        return -1;
    }

    private static void getGradeLine(ItemTooltipEvent event, MaterialGrade grade) {
        String line = SilentGear.i18n.translate("material", "gradeOnPart", new Object[]{grade.getTranslatedName()});
        event.getToolTip().add(TextFormatting.AQUA + line);
    }

    private static void getPartStatLines(ItemTooltipEvent event, ItemStack stack, ItemPart part) {
        ItemPartData partData = ItemPartData.instance(part, MaterialGrade.fromStack(stack), stack);
        for (ItemStat stat : ItemStat.ALL_STATS.values()) {
            StatInstance inst;
            Collection<StatInstance> modifiers = part.getStatModifiers(stat, partData);
            if (modifiers.isEmpty() || !(inst = stat.computeForDisplay(0.0f, partData.getGrade(), modifiers)).shouldList(part, stat, event.getFlags().func_194127_a())) continue;
            boolean isZero = inst.getValue() == 0.0f;
            TextFormatting nameColor = isZero ? TextFormatting.DARK_GRAY : stat.displayColor;
            TextFormatting statColor = isZero ? TextFormatting.DARK_GRAY : TextFormatting.WHITE;
            String nameStr = nameColor + stat.translatedName();
            int decimalPlaces = stat.displayAsInt && inst.getOp() != StatInstance.Operation.MUL1 && inst.getOp() != StatInstance.Operation.MUL2 ? 0 : 2;
            String statStr = statColor + REGEX_TRIM_TO_INT.matcher(inst.formattedString(decimalPlaces, false)).replaceFirst("");
            if (statStr.contains(".")) {
                statStr = REGEX_REMOVE_TRAILING_ZEROS.matcher(statStr).replaceFirst("");
            }
            if (modifiers.size() > 1) {
                statStr = statStr + "*";
            }
            if (stat == CommonItemStats.ARMOR_DURABILITY) {
                statStr = statStr + "x";
            }
            event.getToolTip().add("- " + SilentGear.i18n.translate("stat", "displayFormat", new Object[]{nameStr, statStr}));
        }
    }
}

