/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.analyzer.ContainerPartAnalyzer;
import net.silentchaos512.gear.block.analyzer.GuiPartAnalyzer;
import net.silentchaos512.gear.block.analyzer.TilePartAnalyzer;
import net.silentchaos512.gear.block.craftingstation.ContainerCraftingStation;
import net.silentchaos512.gear.block.craftingstation.GuiCraftingStation;
import net.silentchaos512.gear.block.craftingstation.TileCraftingStation;
import net.silentchaos512.gear.block.salvager.ContainerSalvager;
import net.silentchaos512.gear.block.salvager.GuiSalvager;
import net.silentchaos512.gear.block.salvager.TileSalvager;
import net.silentchaos512.gear.item.blueprint.book.ContainerBlueprintBook;
import net.silentchaos512.gear.item.blueprint.book.GuiBlueprintBook;

public class GuiHandlerSilentGear
implements IGuiHandler {
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = world.func_175625_s(pos);
        GuiType guiType = GuiType.byId(ID);
        if (tile == null && guiType != GuiType.BLUEPRINT_BOOK) {
            SilentGear.log.warn("Missing TileEntity at ({}, {}, {})!", new Object[]{x, y, z});
            return null;
        }
        switch (guiType) {
            case CRAFTING_STATION: {
                if (tile instanceof TileCraftingStation) {
                    TileCraftingStation tileCrafting = (TileCraftingStation)tile;
                    return new ContainerCraftingStation(player.field_71071_by, world, pos, tileCrafting);
                }
                return null;
            }
            case PART_ANALYZER: {
                if (tile instanceof TilePartAnalyzer) {
                    TilePartAnalyzer tileAnalyzer = (TilePartAnalyzer)tile;
                    return new ContainerPartAnalyzer(player.field_71071_by, (IInventory)tileAnalyzer);
                }
                return null;
            }
            case SALVAGER: {
                if (tile instanceof TileSalvager) {
                    TileSalvager tileSalvager = (TileSalvager)tile;
                    return new ContainerSalvager(player.field_71071_by, (IInventory)tileSalvager);
                }
                return null;
            }
            case BLUEPRINT_BOOK: {
                EnumHand hand = x == 1 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
                ItemStack stack = player.func_184586_b(hand);
                return new ContainerBlueprintBook(stack, player.field_71071_by, hand);
            }
        }
        SilentGear.log.warn("No GUI with ID {}!", new Object[]{ID});
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = world.func_175625_s(pos);
        GuiType guiType = GuiType.byId(ID);
        if (tile == null && guiType != GuiType.BLUEPRINT_BOOK) {
            SilentGear.log.warn("Missing TileEntity at ({}, {}, {})!", new Object[]{x, y, z});
            return null;
        }
        switch (guiType) {
            case CRAFTING_STATION: {
                if (tile instanceof TileCraftingStation) {
                    TileCraftingStation tileCrafting = (TileCraftingStation)tile;
                    ContainerCraftingStation container = new ContainerCraftingStation(player.field_71071_by, world, pos, tileCrafting);
                    return new GuiCraftingStation(tileCrafting, container);
                }
                return null;
            }
            case PART_ANALYZER: {
                if (tile instanceof TilePartAnalyzer) {
                    TilePartAnalyzer tileAnalyzer = (TilePartAnalyzer)tile;
                    return new GuiPartAnalyzer(player.field_71071_by, tileAnalyzer);
                }
                return null;
            }
            case SALVAGER: {
                if (tile instanceof TileSalvager) {
                    TileSalvager tileSalvager = (TileSalvager)tile;
                    return new GuiSalvager(player.field_71071_by, tileSalvager);
                }
            }
            case BLUEPRINT_BOOK: {
                ContainerBlueprintBook container = (ContainerBlueprintBook)((Object)this.getServerGuiElement(ID, player, world, x, y, z));
                return container != null ? new GuiBlueprintBook(container) : null;
            }
        }
        SilentGear.log.warn("No GUI with ID {}!", new Object[]{ID});
        return null;
    }

    public static enum GuiType {
        INVALID,
        CRAFTING_STATION,
        PART_ANALYZER,
        SALVAGER,
        BLUEPRINT_BOOK;

        public final int id = this.ordinal() - 1;

        static GuiType byId(int id) {
            for (GuiType type : GuiType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return INVALID;
        }

        public void open(EntityPlayer player, World world, BlockPos pos) {
            player.openGui((Object)SilentGear.instance, this.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        public void open(EntityPlayer player, World world, int subtype) {
            player.openGui((Object)SilentGear.instance, this.id, world, subtype, 0, 0);
        }
    }
}

