/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.lib.client.gui.button.GuiDropDownElement;
import net.silentchaos512.lib.client.gui.button.GuiDropDownList;
import net.silentchaos512.lib.util.AssetUtil;
import net.silentchaos512.lib.util.StringUtil;

public class GuiItemParts
extends GuiScreen {
    private static final int BUTTON_SPACING = 20;
    private static final int BUTTON_ROW_LENGTH = 12;
    private static final int BUTTON_INITIAL_OFFSET = 5;
    private static final ResourceLocation TEX_WHITE = new ResourceLocation("silentgear", "textures/gui/white.png");
    private int lastButtonId = 6900;
    private List<ItemPart> partList = new ArrayList<ItemPart>();
    private List<PartButton> partButtons = new ArrayList<PartButton>();
    private ItemPart selectedPart = null;
    private List<StringPair> selectedPartInfo = null;

    public void func_73866_w_() {
        super.func_73866_w_();
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        GuiDropDownList dropDownList = new GuiDropDownList(this.lastButtonId++, res.func_78326_a() - 120, 5, "Sort Order", GuiDropDownList.ExpandDirection.DOWN);
        dropDownList.addElement(new GuiDropDownElement(this.lastButtonId++, "Name", b -> this.sortParts(false, Comparator.comparing(part -> part.getTranslatedName(null, ItemStack.field_190927_a)))), (Collection)this.field_146292_n);
        dropDownList.addElement(new GuiDropDownElement(this.lastButtonId++, "Type", b -> this.sortParts(false, Comparator.comparing(part -> part.getType().getName()))), (Collection)this.field_146292_n);
        ItemStat.ALL_STATS.values().stream().filter(stat -> !stat.isHidden()).forEachOrdered(stat -> dropDownList.addElement(new GuiDropDownElement(this.lastButtonId++, stat.translatedName(), b -> this.sortParts(true, Comparator.comparingDouble(part -> part.computeStatValue((ItemStat)stat)))), (Collection)this.field_146292_n));
        this.field_146292_n.add(dropDownList);
        int i = 0;
        for (ItemPart part : PartRegistry.getValues()) {
            if (part.isBlacklisted()) continue;
            this.partList.add(part);
            int x = i % 12;
            int y = i / 12;
            PartButton button = new PartButton(part, this.lastButtonId++, x * 20 + 5, y * 20 + 5);
            this.partButtons.add(button);
            this.field_146292_n.add(button);
            ++i;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void layoutPartButtons() {
        int i = 0;
        for (PartButton button : this.partButtons) {
            button.field_146128_h = i % 12 * 20 + 5;
            button.field_146129_i = i / 12 * 20 + 5;
            ++i;
        }
    }

    private void sortParts(boolean reversed, Comparator<ItemPart> comparator) {
        this.partList.sort(comparator);
        ArrayList<PartButton> sortedList = new ArrayList<PartButton>();
        block0: for (ItemPart part : this.partList) {
            for (PartButton button : this.partButtons) {
                if (button.part != part) continue;
                sortedList.add(button);
                continue block0;
            }
        }
        this.partButtons = sortedList;
        if (reversed) {
            this.partList = Lists.reverse(this.partList);
            this.partButtons = Lists.reverse(this.partButtons);
        }
        this.layoutPartButtons();
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof PartButton) {
            PartButton partButton = (PartButton)button;
            this.selectedPart = partButton.part;
            this.selectedPartInfo = this.getPartInfo(this.selectedPart);
        } else if (button instanceof GuiDropDownElement) {
            this.selectedPart = null;
            if (this.selectedPartInfo != null) {
                this.selectedPartInfo.clear();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawSelectedPartInfo();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof PartButton)) continue;
            ((PartButton)button).drawHover(this.field_146297_k, mouseX, mouseY);
        }
    }

    private void drawSelectedPartInfo() {
        if (this.selectedPart != null && !this.selectedPartInfo.isEmpty()) {
            ScaledResolution res = new ScaledResolution(this.field_146297_k);
            ItemStack stack = this.selectedPart.getCraftingStack();
            AssetUtil.renderStackToGui((ItemStack)stack, (int)(res.func_78326_a() - 194), (int)30, (float)2.5f);
            int maxWidth = 140;
            int x = res.func_78326_a() - 150;
            int y = 35;
            String translatedName = this.selectedPart.getTranslatedName(ItemPartData.instance(this.selectedPart), ItemStack.field_190927_a);
            StringUtil.renderScaledAsciiString((FontRenderer)this.field_146297_k.field_71466_p, (String)translatedName, (int)x, (int)y, (int)0xFFFFFF, (boolean)false, (float)1.0f);
            String originType = this.selectedPart.getOrigin().isUserDefined() ? " (user defined)" : " (built-in)";
            String regName = TextFormatting.GRAY + this.selectedPart.getRegistryName().toString() + originType;
            StringUtil.renderScaledAsciiString((FontRenderer)this.field_146297_k.field_71466_p, (String)regName, (int)x, (int)(y + 10), (int)0xFFFFFF, (boolean)false, (float)0.5f);
            String typeName = SilentGear.i18n.translate("part", "type." + this.selectedPart.getType().getName(), new Object[]{this.selectedPart.getTier()});
            StringUtil.renderScaledAsciiString((FontRenderer)this.field_146297_k.field_71466_p, (String)(TextFormatting.GREEN + typeName), (int)x, (int)(y + 16), (int)0xFFFFFF, (boolean)false, (float)0.8f);
            y += 30;
            for (StringPair pair : this.selectedPartInfo) {
                this.field_146289_q.func_78276_b(pair.first, x, y, 0xFFFFFF);
                int width2 = this.field_146289_q.func_78256_a(pair.second);
                this.field_146289_q.func_78276_b(pair.second, x + 140 - width2, y, 0xFFFFFF);
                y += 10;
            }
        }
    }

    private List<StringPair> getPartInfo(ItemPart part) {
        ArrayList<StringPair> list = new ArrayList<StringPair>();
        ItemPartData partData = ItemPartData.instance(part);
        for (ItemStat stat : ItemStat.ALL_STATS.values()) {
            StatInstance inst;
            Collection<StatInstance> modifiers = part.getStatModifiers(stat, partData);
            if (modifiers.isEmpty() || !(inst = stat.computeForDisplay(0.0f, MaterialGrade.NONE, modifiers)).shouldList(part, stat, true)) continue;
            boolean isZero = inst.getValue() == 0.0f;
            TextFormatting nameColor = isZero ? TextFormatting.DARK_GRAY : stat.displayColor;
            TextFormatting statColor = isZero ? TextFormatting.DARK_GRAY : TextFormatting.WHITE;
            String nameStr = nameColor + SilentGear.i18n.translate("stat." + stat.getName(), new Object[0]);
            int decimalPlaces = stat.displayAsInt && inst.getOp() != StatInstance.Operation.MUL1 && inst.getOp() != StatInstance.Operation.MUL2 ? 0 : 2;
            String statStr = statColor + inst.formattedString(decimalPlaces, false).replaceFirst("\\.0+$", "");
            if (statStr.contains(".")) {
                statStr = statStr.replaceFirst("0+$", "");
            }
            if (modifiers.size() > 1) {
                statStr = statStr + "*";
            }
            if (stat == CommonItemStats.ARMOR_DURABILITY) {
                statStr = statStr + "x";
            }
            list.add(StringPair.of(nameStr, statStr));
        }
        return list;
    }

    private static final class StringPair {
        private final String first;
        private final String second;

        private StringPair(String first, String second) {
            this.first = first;
            this.second = second;
        }

        private static StringPair of() {
            return StringPair.of("", "");
        }

        private static StringPair of(String first) {
            return StringPair.of(first, "");
        }

        private static StringPair of(String first, String second) {
            return new StringPair(first, second);
        }
    }

    public static class PartButton
    extends GuiButton {
        private static final int SIZE = 16;
        private final ItemPart part;

        PartButton(ItemPart part, int buttonId, int x, int y) {
            this(part, buttonId, x, y, 16, 16);
        }

        PartButton(ItemPart part, int buttonId, int x, int y, int widthIn, int heightIn) {
            super(buttonId, x, y, widthIn, heightIn, part.getRegistryName().toString());
            this.part = part;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                AssetUtil.renderStackToGui((ItemStack)this.part.getCraftingStack(), (int)this.field_146128_h, (int)this.field_146129_i, (float)1.0f);
            }
        }

        void drawHover(Minecraft mc, int mouseX, int mouseY) {
            if (this.func_146115_a()) {
                ScaledResolution res = new ScaledResolution(mc);
                ItemStack craftingStack = this.part.getCraftingStack();
                List tooltip = craftingStack.func_82840_a((EntityPlayer)mc.field_71439_g, () -> false);
                GuiUtils.preItemToolTip((ItemStack)craftingStack);
                GuiUtils.drawHoveringText((List)tooltip, (int)mouseX, (int)mouseY, (int)res.func_78326_a(), (int)res.func_78328_b(), (int)-1, (FontRenderer)mc.field_71466_p);
                GuiUtils.postItemToolTip();
            }
        }
    }
}

