/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartPositions;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.client.ColorHandlers;
import net.silentchaos512.gear.client.models.AbstractToolModel;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ArmorItemModel
implements IModel {
    public static final IModel MODEL = new ArmorItemModel();
    @Nullable
    private final ResourceLocation textureMain;

    public ArmorItemModel() {
        this.textureMain = null;
    }

    public ArmorItemModel(@Nullable ResourceLocation textureMain) {
        this.textureMain = textureMain;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        ResourceLocation main = null;
        if (textures.containsKey((Object)"main")) {
            main = new ResourceLocation((String)textures.get((Object)"main"));
        }
        return new ArmorItemModel(main);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ResourceLocation main = null;
        if (customData.containsKey((Object)"main")) {
            main = new ResourceLocation((String)customData.get((Object)"main"));
        }
        return new ArmorItemModel(main);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String armorClass : ModItems.armorClasses.keySet()) {
            for (PartMain part : PartRegistry.getMains()) {
                ResourceLocation textureBroken;
                ItemPartData partData = ItemPartData.instance(part);
                ResourceLocation textureMain = partData.getTexture(ItemStack.field_190927_a, armorClass, PartPositions.ARMOR, 0);
                if (textureMain != null) {
                    builder.add((Object)textureMain);
                }
                if ((textureBroken = partData.getBrokenTexture(ItemStack.field_190927_a, armorClass, PartPositions.ARMOR)) == null) continue;
                builder.add((Object)textureBroken);
            }
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = TRSRTransformation.identity();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder texBuilder = ImmutableList.builder();
        if (this.textureMain != null) {
            texBuilder.add((Object)this.textureMain);
        }
        ImmutableList textures = texBuilder.build();
        int layerCount = textures.size();
        IBakedModel model = new ItemLayerModel(textures).bake(state, format, bakedTextureGetter);
        builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        return new Baked(this, this.createQuadsMap(model, layerCount), format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), new HashMap<String, IBakedModel>());
    }

    private ImmutableList<ImmutableList<BakedQuad>> createQuadsMap(IBakedModel model, int layerCount) {
        ArrayList<ImmutableList.Builder> list = new ArrayList<ImmutableList.Builder>();
        for (int i = 0; i < layerCount; ++i) {
            list.add(ImmutableList.builder());
        }
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            ((ImmutableList.Builder)list.get(quad.func_178211_c())).add((Object)quad);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableList.Builder b : list) {
            builder.add((Object)b.build());
        }
        return builder.build();
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static final class Baked
    extends AbstractToolModel {
        public static Baked instance;

        public Baked(IModel parent, ImmutableList<ImmutableList<BakedQuad>> immutableList, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            super(parent, immutableList, format, transforms, cache);
            instance = this;
        }

        public ItemOverrideList func_188617_f() {
            return OverrideHandler.INSTANCE;
        }

        public boolean func_188618_c() {
            return true;
        }
    }

    private static final class OverrideHandler
    extends ItemOverrideList {
        static final OverrideHandler INSTANCE = new OverrideHandler();

        OverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (!(stack.func_77973_b() instanceof ICoreArmor)) {
                return originalModel;
            }
            Baked model = (Baked)originalModel;
            ICoreArmor itemArmor = (ICoreArmor)stack.func_77973_b();
            String key = GearData.getCachedModelKey(stack, 0);
            StackHelper.getTagCompound((ItemStack)stack, (boolean)true).func_74778_a("debug_modelkey", key);
            if (!GearClientHelper.modelCache.containsKey(key)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                this.processTexture(stack, itemArmor.getGearClass(), PartPositions.ARMOR, itemArmor.getPrimaryPart(stack), GearHelper.isBroken(stack), (ImmutableMap.Builder<String, String>)builder);
                IModel parent = model.getParent().retexture(builder.build());
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.getVertexFormat(), textureGetter);
                GearClientHelper.modelCache.put(key, bakedModel);
                return bakedModel;
            }
            ColorHandlers.gearColorCache.put(key, new Integer[]{itemArmor.getPrimaryPart(stack).getColor(stack, 0)});
            return GearClientHelper.modelCache.get(key);
        }

        private void processTexture(ItemStack stack, String toolClass, IPartPosition position, ItemPartData part, boolean isBroken, ImmutableMap.Builder<String, String> builder) {
            ResourceLocation texture;
            if (part != null && (texture = isBroken ? part.getBrokenTexture(stack, toolClass, position) : part.getTexture(stack, toolClass, position, 0)) != null) {
                builder.put((Object)position.getModelIndex(), (Object)texture.toString());
            }
        }
    }

    public static final class Loader
    implements ICustomModelLoader {
        public static Loader INSTANCE = new Loader();

        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            boolean matchesPath = ModItems.armorClasses.keySet().stream().anyMatch(s -> modelLocation.func_110623_a().equals(s));
            return modelLocation.func_110624_b().equals("silentgear") && matchesPath;
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }
    }
}

