/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartPositions;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.client.ColorHandlers;
import net.silentchaos512.gear.client.models.AbstractToolModel;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModMaterials;
import net.silentchaos512.gear.item.ToolHead;

public class ToolHeadModel
implements IModel {
    public static final IModel MODEL = new ToolHeadModel();
    @Nullable
    private final ResourceLocation textureHead;
    @Nullable
    private final ResourceLocation textureGuard;
    @Nullable
    private final ResourceLocation textureHighlight;

    public ToolHeadModel() {
        this.textureHead = null;
        this.textureGuard = null;
        this.textureHighlight = null;
    }

    public ToolHeadModel(@Nullable ResourceLocation textureHead, @Nullable ResourceLocation textureGuard, @Nullable ResourceLocation textureHighlight) {
        this.textureHead = textureHead;
        this.textureGuard = textureGuard;
        this.textureHighlight = textureHighlight;
    }

    @Nonnull
    public IModel retexture(ImmutableMap<String, String> textures) {
        ResourceLocation head = null;
        if (textures.containsKey((Object)"head")) {
            head = new ResourceLocation((String)textures.get((Object)"head"));
        }
        ResourceLocation guard = null;
        if (textures.containsKey((Object)"guard")) {
            guard = new ResourceLocation((String)textures.get((Object)"guard"));
        }
        ResourceLocation highlight = null;
        if (textures.containsKey((Object)"highlight")) {
            highlight = new ResourceLocation((String)textures.get((Object)"highlight"));
        }
        return new ToolHeadModel(head, guard, highlight);
    }

    @Nonnull
    public IModel process(ImmutableMap<String, String> customData) {
        ResourceLocation head = null;
        if (customData.containsKey((Object)"head")) {
            head = new ResourceLocation((String)customData.get((Object)"head"));
        }
        ResourceLocation guard = null;
        if (customData.containsKey((Object)"guard")) {
            guard = new ResourceLocation((String)customData.get((Object)"guard"));
        }
        ResourceLocation highlight = null;
        if (customData.containsKey((Object)"highlight")) {
            highlight = new ResourceLocation((String)customData.get((Object)"highlight"));
        }
        return new ToolHeadModel(head, guard, highlight);
    }

    @Nonnull
    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String toolClass : ModItems.toolClasses.keySet()) {
            for (PartMain part : PartRegistry.getMains()) {
                ResourceLocation textureGuard;
                ItemPartData partData = ItemPartData.instance(part);
                ResourceLocation textureHead = partData.getTexture(ItemStack.field_190927_a, toolClass, PartPositions.HEAD, 0);
                if (textureHead != null) {
                    builder.add((Object)textureHead);
                }
                if (!"sword".equals(toolClass) || (textureGuard = partData.getTexture(ItemStack.field_190927_a, toolClass, PartPositions.GUARD, 0)) == null) continue;
                builder.add((Object)textureGuard);
            }
            ItemPartData highlight = ItemPartData.instance(ModMaterials.highlight);
            ResourceLocation highlightTexture = highlight.getTexture(ItemStack.field_190927_a, toolClass, PartPositions.HIGHLIGHT, 0);
            if (highlightTexture == null) continue;
            builder.add((Object)highlightTexture);
        }
        return builder.build();
    }

    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder texBuilder = ImmutableList.builder();
        if (this.textureHead != null) {
            texBuilder.add((Object)this.textureHead);
        }
        if (this.textureGuard != null) {
            texBuilder.add((Object)this.textureGuard);
        }
        if (this.textureHighlight != null) {
            texBuilder.add((Object)this.textureHighlight);
        }
        ImmutableList textures = texBuilder.build();
        IBakedModel model = new ItemLayerModel(textures).bake(state, format, bakedTextureGetter);
        builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        return new Baked((IModel)this, (ImmutableList<BakedQuad>)builder.build(), format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), (Map<String, IBakedModel>)new HashMap<String, IBakedModel>());
    }

    @Nonnull
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Nullable
    private static ItemPartData getHighlightPart(@Nullable ItemPartData primary, ItemStack stack) {
        if (primary == null) {
            return null;
        }
        if (primary.getPart().getDisplayProperties(primary, stack, 0).hasHighlight()) {
            return ItemPartData.instance(ModMaterials.highlight);
        }
        return null;
    }

    public static final class Baked
    extends AbstractToolModel {
        public static Baked instance;

        public Baked(IModel parent, ImmutableList<BakedQuad> quads, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            super(parent, Baked.buildQuadList(quads), format, transforms, cache);
            instance = this;
        }

        public ItemOverrideList func_188617_f() {
            return OverrideHandler.INSTANCE;
        }

        private static ImmutableList<ImmutableList<BakedQuad>> buildQuadList(ImmutableList<BakedQuad> quads) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(quads);
            return builder.build();
        }

        public boolean func_188618_c() {
            return false;
        }
    }

    private static final class OverrideHandler
    extends ItemOverrideList {
        public static final OverrideHandler INSTANCE = new OverrideHandler();

        public OverrideHandler() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (stack.func_77973_b() != ModItems.toolHead) {
                return originalModel;
            }
            Baked model = (Baked)originalModel;
            String toolClass = ToolHead.getToolClass(stack);
            boolean hasGuard = "sword".equals(toolClass);
            ItemPartData primaryPart = ToolHead.getPrimaryPart(stack);
            ItemPartData secondaryPart = hasGuard ? ToolHead.getSecondaryPart(stack) : null;
            ItemPartData highlightPart = ToolHeadModel.getHighlightPart(primaryPart, stack);
            String key = ToolHead.getModelKey(toolClass, primaryPart, secondaryPart);
            if (!GearClientHelper.modelCache.containsKey(key)) {
                ResourceLocation textureHighlight;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                ResourceLocation textureHead = primaryPart == null ? null : primaryPart.getTexture(stack, toolClass, PartPositions.HEAD, 0);
                ResourceLocation textureGuard = secondaryPart == null ? null : secondaryPart.getTexture(stack, toolClass, PartPositions.GUARD, 0);
                ResourceLocation resourceLocation = textureHighlight = highlightPart == null ? null : highlightPart.getTexture(stack, toolClass, PartPositions.HIGHLIGHT, 0);
                if (textureHead != null) {
                    builder.put((Object)"head", (Object)textureHead.toString());
                }
                if (textureGuard != null) {
                    builder.put((Object)"guard", (Object)textureGuard.toString());
                }
                if (textureHighlight != null) {
                    builder.put((Object)"highlight", (Object)textureHighlight.toString());
                }
                IModel parent = model.getParent().retexture(builder.build());
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.getVertexFormat(), textureGetter);
                GearClientHelper.modelCache.put(key, bakedModel);
                ColorHandlers.gearColorCache.put(key, (Integer[])Stream.of(primaryPart, secondaryPart).filter(Objects::nonNull).map(part -> part.getColor(stack, 0)).toArray(Integer[]::new));
                return bakedModel;
            }
            return GearClientHelper.modelCache.get(key);
        }
    }

    public static final class Loader
    implements ICustomModelLoader {
        public static Loader INSTANCE = new Loader();

        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("silentgear") && modelLocation.func_110623_a().equals("tool_head");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return MODEL;
        }
    }
}

