/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartPositions;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.client.ColorHandlers;
import net.silentchaos512.gear.client.models.AbstractToolModel;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.gear.CoreBow;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.StackHelper;

public final class ToolModel
implements IModel {
    private static final IModel MODEL = new ToolModel();
    public static final Map<UUID, Float> bowPull = new HashMap<UUID, Float>();
    private final ImmutableMap<String, String> textures;

    private ToolModel() {
        this.textures = ImmutableMap.of();
    }

    private ToolModel(ImmutableMap<String, String> textures) {
        this.textures = textures;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        return new ToolModel(textures);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        return new ToolModel(customData);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String toolClass : ModItems.toolClasses.keySet()) {
            boolean hasGuard = "sword".equals(toolClass);
            ICoreItem item = ModItems.toolClasses.get(toolClass);
            for (int frame = 0; frame < item.getAnimationFrames(); ++frame) {
                for (ItemPart part : PartRegistry.getValues()) {
                    ResourceLocation texGuard;
                    ResourceLocation texBroken;
                    if (part.isBlacklisted()) continue;
                    ItemPartData partData = ItemPartData.instance(part);
                    ResourceLocation texBasic = partData.getTexture(ItemStack.field_190927_a, toolClass, part.getPartPosition(), frame);
                    if (texBasic != null) {
                        builder.add((Object)texBasic);
                    }
                    if ((texBroken = partData.getBrokenTexture(ItemStack.field_190927_a, toolClass, part.getPartPosition())) != null) {
                        builder.add((Object)texBroken);
                    }
                    if (!hasGuard || !(part instanceof PartMain) || (texGuard = partData.getTexture(ItemStack.field_190927_a, toolClass, PartPositions.GUARD, frame)) == null) continue;
                    builder.add((Object)texGuard);
                }
            }
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList textures = (ImmutableList)IPartPosition.RENDER_LAYERS.stream().map(IPartPosition::getModelIndex).map(arg_0 -> this.textures.get(arg_0)).filter(Objects::nonNull).map(ResourceLocation::new).collect(ImmutableList.toImmutableList());
        IBakedModel model = new ItemLayerModel(textures).bake(state, format, bakedTextureGetter);
        builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        int layerCount = textures.size();
        return new Baked(this, ToolModel.createQuadsMap(model, layerCount), format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), new HashMap<String, IBakedModel>());
    }

    private static ImmutableList<ImmutableList<BakedQuad>> createQuadsMap(IBakedModel model, int layerCount) {
        ArrayList<ImmutableList.Builder> list = new ArrayList<ImmutableList.Builder>();
        for (int i = 0; i < layerCount; ++i) {
            list.add(ImmutableList.builder());
        }
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            ((ImmutableList.Builder)list.get(quad.func_178211_c())).add((Object)quad);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableList.Builder b : list) {
            builder.add((Object)b.build());
        }
        return builder.build();
    }

    @Nonnull
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static final class Baked
    extends AbstractToolModel {
        public static Baked instance;

        Baked(IModel parent, ImmutableList<ImmutableList<BakedQuad>> immutableList, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            super(parent, immutableList, format, transforms, cache);
            instance = this;
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return OverrideHandler.INSTANCE;
        }

        public boolean func_188618_c() {
            return true;
        }
    }

    private static final class OverrideHandler
    extends ItemOverrideList {
        public static final OverrideHandler INSTANCE = new OverrideHandler();

        OverrideHandler() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (!(stack.func_77973_b() instanceof ICoreTool)) {
                return originalModel;
            }
            int animationFrame = this.getAnimationFrame(stack, world, entity);
            String key = GearData.getCachedModelKey(stack, animationFrame);
            StackHelper.getTagCompound((ItemStack)stack, (boolean)true).func_74778_a("debug_modelkey", key);
            if (!GearClientHelper.modelCache.containsKey(key)) {
                ICoreTool itemTool = (ICoreTool)stack.func_77973_b();
                String toolClass = itemTool.getGearClass();
                boolean isBroken = GearHelper.isBroken(stack);
                PartDataList parts = GearData.getConstructionParts(stack);
                LinkedHashMap<IPartPosition, ItemPartData> renderLayers = new LinkedHashMap<IPartPosition, ItemPartData>();
                for (IPartPosition position : IPartPosition.RENDER_LAYERS) {
                    if (position == PartPositions.HEAD) {
                        renderLayers.put(PartPositions.HEAD, itemTool.getPrimaryPart(stack));
                        continue;
                    }
                    if (position == PartPositions.GUARD && itemTool.hasSwordGuard()) {
                        renderLayers.put(PartPositions.GUARD, itemTool.getSecondaryPart(stack));
                        continue;
                    }
                    if (position == PartPositions.ROD) {
                        renderLayers.put(PartPositions.ROD, itemTool.getRodPart(stack));
                        continue;
                    }
                    ItemPartData part2 = parts.firstInPosition(position);
                    if (part2 == null) continue;
                    renderLayers.put(position, part2);
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                renderLayers.forEach((pos, part) -> OverrideHandler.processTexture(stack, toolClass, pos, part, animationFrame, isBroken, (ImmutableMap.Builder<String, String>)builder));
                Baked model = (Baked)originalModel;
                IModel parent = model.getParent().retexture(builder.build());
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.getVertexFormat(), textureGetter);
                GearClientHelper.modelCache.put(key, bakedModel);
                ColorHandlers.gearColorCache.put(key, (Integer[])renderLayers.values().stream().map(part -> part.getColor(stack, animationFrame)).toArray(Integer[]::new));
                return bakedModel;
            }
            return GearClientHelper.modelCache.get(key);
        }

        private static void processTexture(ItemStack stack, String toolClass, IPartPosition position, @Nullable ItemPartData part, int animationFrame, boolean isBroken, ImmutableMap.Builder<String, String> builder) {
            if (part != null) {
                ResourceLocation texture;
                ResourceLocation resourceLocation = texture = isBroken ? part.getBrokenTexture(stack, toolClass, position) : part.getTexture(stack, toolClass, position, animationFrame);
                if (texture != null) {
                    builder.put((Object)position.getModelIndex(), (Object)texture.toString());
                }
            }
        }

        private int getAnimationFrame(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            UUID uuid;
            if (stack.func_77973_b() instanceof CoreBow && bowPull.containsKey(uuid = GearData.getUUID(stack))) {
                float pull = bowPull.get(uuid).floatValue();
                if (pull > 0.9f) {
                    return 3;
                }
                if (pull > 0.65f) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }
    }

    public static final class Loader
    implements ICustomModelLoader {
        public static Loader INSTANCE = new Loader();

        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }

        public boolean accepts(@Nonnull ResourceLocation modelLocation) {
            boolean matchesPath = ModItems.toolClasses.keySet().stream().anyMatch(s -> modelLocation.func_110623_a().equals(s));
            return modelLocation.func_110624_b().equals("silentgear") && matchesPath;
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return MODEL;
        }
    }
}

