/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.util.TooltipFlagTC;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.StackHelper;

@SideOnly(value=Side.CLIENT)
public final class GearClientHelper {
    public static Map<String, IBakedModel> modelCache = new HashMap<String, IBakedModel>();

    private GearClientHelper() {
    }

    public static void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        TooltipFlagTC flagTC = flag instanceof TooltipFlagTC ? (TooltipFlagTC)flag : TooltipFlagTC.withModifierKeys(flag.func_194127_a(), true, true);
        GearClientHelper.addInformation(stack, world, tooltip, flagTC);
    }

    public static void addInformation(ItemStack stack, World world, List<String> tooltip, TooltipFlagTC flag) {
        LoaderState state = Loader.instance().getLoaderState();
        if (state == LoaderState.INITIALIZATION || state == LoaderState.SERVER_ABOUT_TO_START || state == LoaderState.SERVER_STOPPING) {
            return;
        }
        if (stack.func_77973_b() instanceof ICoreItem) {
            NBTTagCompound tagCompound;
            PartDataList constructionParts;
            boolean ctrlDown = flag.ctrlDown;
            boolean altDown = flag.altDown;
            ICoreItem item = (ICoreItem)stack.func_77973_b();
            if (GearHelper.isBroken(stack)) {
                tooltip.add(1, TextFormatting.RED + SilentGear.i18n.translate("misc", "broken", new Object[0]));
            }
            if (GearData.isExampleGear(stack)) {
                tooltip.add(1, TextFormatting.YELLOW + SilentGear.i18n.translate("misc", "exampleOutput1", new Object[0]));
                tooltip.add(2, TextFormatting.YELLOW + SilentGear.i18n.translate("misc", "exampleOutput2", new Object[0]));
            }
            if ((constructionParts = GearData.getConstructionParts(stack)).getMains().isEmpty()) {
                tooltip.add(TextFormatting.RED + SilentGear.i18n.translate("misc", "invalidParts", new Object[0]));
                tooltip.add(TextFormatting.RED + SilentGear.i18n.translate("misc", "lockedStats", new Object[0]));
            } else if (GearData.hasLockedStats(stack)) {
                tooltip.add(TextFormatting.YELLOW + SilentGear.i18n.translate("misc", "lockedStats", new Object[0]));
            }
            Collections.reverse(constructionParts);
            for (ItemPartData data : constructionParts) {
                data.getPart().addInformation(data, stack, world, tooltip, flag.func_194127_a());
            }
            TraitHelper.getTraits(constructionParts).forEach((trait, level) -> tooltip.add(trait.getNameColor() + trait.getTranslatedName((int)level)));
            float synergyDisplayValue = GearData.getSynergyDisplayValue(stack);
            TextFormatting color = synergyDisplayValue < 1.0f ? TextFormatting.RED : (synergyDisplayValue > 1.0f ? TextFormatting.GREEN : TextFormatting.WHITE);
            tooltip.add("Synergy: " + color + String.format("%d%%", (int)(100.0f * synergyDisplayValue)));
            if (flag.func_194127_a() && (tagCompound = StackHelper.getTagCompound((ItemStack)stack, (boolean)true)).func_74764_b("debug_modelkey")) {
                tooltip.add(TextFormatting.DARK_GRAY + tagCompound.func_74779_i("debug_modelkey"));
            }
            String strStats = TextFormatting.GOLD + SilentGear.i18n.translate("misc", "tooltip.stats.name", new Object[0]);
            if (ctrlDown && flag.showStats) {
                tooltip.add(strStats);
                for (ItemStat stat : item.getRelevantStats(stack)) {
                    float statValue = GearData.getStat(stack, stat);
                    float totalArmor = -1.0f;
                    if (item instanceof CoreArmor) {
                        if (stat == CommonItemStats.ARMOR) {
                            totalArmor = statValue;
                            statValue = (float)((CoreArmor)item).getArmorProtection(stack);
                        } else if (stat == CommonItemStats.ARMOR_TOUGHNESS) {
                            totalArmor = statValue;
                            statValue /= 4.0f;
                        }
                    }
                    StatInstance inst = new StatInstance("display_" + stat.getName(), statValue, StatInstance.Operation.AVG);
                    String nameStr = "- " + stat.displayColor + SilentGear.i18n.translate("stat." + stat.getName(), new Object[0]);
                    String statStr = inst.formattedString(stat.displayAsInt ? 0 : 1, false);
                    if (stat == CommonItemStats.DURABILITY) {
                        int durabilityLeft = stack.func_77958_k() - stack.func_77952_i();
                        int durabilityMax = stack.func_77958_k();
                        statStr = SilentGear.i18n.translate("stat", "durabilityFormat", new Object[]{durabilityLeft, durabilityMax});
                    } else if (stat == CommonItemStats.ARMOR || stat == CommonItemStats.ARMOR_TOUGHNESS) {
                        String str1 = String.format("%.1f", Float.valueOf(statValue));
                        String str2 = String.format("%.1f", Float.valueOf(totalArmor));
                        statStr = SilentGear.i18n.translate("stat", "armorFormat", new Object[]{str1, str2});
                    }
                    tooltip.add(SilentGear.i18n.translate("stat", "displayFormat", new Object[]{nameStr, statStr}));
                }
            } else if (flag.showStats) {
                strStats = strStats + " " + TextFormatting.GRAY + SilentGear.i18n.translate("misc", "tooltip.stats.key", new Object[0]);
                tooltip.add(strStats);
            }
            String strConstruction = TextFormatting.GOLD + SilentGear.i18n.translate("misc", "tooltip.construction.name", new Object[0]);
            if (altDown && flag.showConstruction) {
                tooltip.add(strConstruction);
                Collections.reverse(constructionParts);
                GearClientHelper.tooltipListParts(stack, tooltip, constructionParts);
            } else if (flag.showConstruction) {
                strConstruction = strConstruction + " " + TextFormatting.GRAY + SilentGear.i18n.translate("misc", "tooltip.construction.key", new Object[0]);
                tooltip.add(strConstruction);
            }
        }
    }

    public static void tooltipListParts(ItemStack gear, List<String> tooltip, Collection<ItemPartData> parts) {
        for (ItemPartData part : parts) {
            String str = "- " + part.getNameColor() + part.getTranslatedName(gear);
            if (part.getPart() instanceof PartMain) {
                str = str + TextFormatting.RESET + " (" + part.getGrade().getTranslatedName() + ")";
            }
            tooltip.add(str);
        }
    }

    public static boolean hasEffect(ItemStack stack) {
        return stack.func_77948_v();
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    public static Map<String, ItemPartData> getRenderParts(ItemStack stack) {
        LinkedHashMap<String, ItemPartData> map = new LinkedHashMap<String, ItemPartData>();
        ICoreTool item = (ICoreTool)stack.func_77973_b();
        String itemClass = item.getGearClass();
        boolean hasGuard = "sword".equals(itemClass);
        ItemPartData partHead = item.getPrimaryPart(stack);
        ItemPartData partGuard = hasGuard ? item.getSecondaryPart(stack) : null;
        ItemPartData partRod = item.getRodPart(stack);
        ItemPartData partTip = item.getTipPart(stack);
        ItemPartData partBowstring = item.getBowstringPart(stack);
        if (partRod != null) {
            map.put("rod", partRod);
        }
        if (partHead != null) {
            map.put("head", partHead);
        }
        if (partGuard != null) {
            map.put("guard", partGuard);
        }
        if (partTip != null) {
            map.put("tip", partTip);
        }
        if (partBowstring != null) {
            map.put("bowstring", partBowstring);
        }
        return map;
    }
}

