/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CommandSilentGear
extends CommandBase {
    public String func_71517_b() {
        return "silentgear";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"sgear");
    }

    public String func_71518_a(ICommandSender sender) {
        StringBuilder subcommands = new StringBuilder();
        for (SubCommand command : SubCommand.values()) {
            subcommands.append(subcommands.length() != 0 ? ", " : "").append(command.name().toLowerCase(Locale.ROOT));
        }
        return TextFormatting.RED + String.format("Usage: /%s <%s>", this.func_71517_b(), subcommands.toString());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1) {
            this.tell(sender, this.func_71518_a(sender), false, new Object[0]);
            return;
        }
        SubCommand subCommand = SubCommand.fromArgs(args[0]);
        if (subCommand == SubCommand.RESET_MODEL_CACHES) {
            int total = GearClientHelper.modelCache.size();
            GearClientHelper.modelCache.clear();
            this.tell(sender, "Reset gear model caches, removed " + total + " objects", false, new Object[0]);
        } else if (subCommand == SubCommand.REGISTRY_ANALYZE) {
            this.tell(sender, "PartRegistry.all: " + PartRegistry.getValues().size(), false, new Object[0]);
            this.tell(sender, "PartRegistry.mains: " + PartRegistry.getMains().size(), false, new Object[0]);
            this.tell(sender, "PartRegistry.rods: " + PartRegistry.getRods().size(), false, new Object[0]);
            this.tell(sender, "PartRegistry.visibleMains: " + PartRegistry.getVisibleMains().size(), false, new Object[0]);
            this.tell(sender, "PartRegistry.visibleRods: " + PartRegistry.getVisibleRods().size(), false, new Object[0]);
        } else if (subCommand == SubCommand.BREAK_ITEM_IN_HAND && sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof ICoreItem) {
                stack.func_77964_b(stack.func_77958_k());
                GearData.recalculateStats(player, stack);
                this.tell(sender, "(\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b", false, new Object[0]);
            } else {
                this.tell(sender, "invalidItemType", true, stack.func_82833_r());
            }
        } else if (subCommand == SubCommand.REPAIR_ITEM_IN_HAND && sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof ICoreItem) {
                stack.func_77964_b(0);
                GearData.recalculateStats(player, stack);
                this.tell(sender, "\u252c\u2500\u252c\u30ce( \u00ba _ \u00ba\u30ce)", false, new Object[0]);
            } else {
                this.tell(sender, "invalidItemType", true, stack.func_82833_r());
            }
        } else if (subCommand == SubCommand.LOCK_STATS && sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof ICoreItem) {
                boolean locked = !GearData.hasLockedStats(stack);
                GearData.setLockedStats(stack, locked);
                String lockStr = locked ? TextFormatting.RED + SilentGear.i18n.translate("command", "lockStats.locked", new Object[0]) : TextFormatting.GREEN + SilentGear.i18n.translate("command", "lockStats.unlocked", new Object[0]);
                this.tell(sender, "lockStats.success", true, stack.func_82833_r(), lockStr);
            } else {
                this.tell(sender, "invalidItemType", true, stack.func_82833_r());
            }
        } else {
            this.tell(sender, this.func_71518_a(sender), false, new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandSilentGear.func_71530_a((String[])args, (String[])SubCommand.getKeys());
        }
        return ImmutableList.of();
    }

    private void tell(ICommandSender sender, String key, boolean fromLocalizationFile, Object ... args) {
        this.tell(sender, TextFormatting.RESET, key, fromLocalizationFile, args);
    }

    private void tell(ICommandSender sender, TextFormatting format, String key, boolean fromLocalizationFile, Object ... args) {
        String value = fromLocalizationFile ? SilentGear.i18n.translate("command", key, args) : key;
        sender.func_145747_a((ITextComponent)new TextComponentString(format + value));
    }

    static enum SubCommand {
        RESET_MODEL_CACHES,
        REGISTRY_ANALYZE,
        BREAK_ITEM_IN_HAND,
        REPAIR_ITEM_IN_HAND,
        LOCK_STATS;


        @Nullable
        static SubCommand fromArgs(String arg) {
            for (SubCommand val : SubCommand.values()) {
                if (!val.name().equalsIgnoreCase(arg)) continue;
                return val;
            }
            return null;
        }

        static String[] getKeys() {
            String[] ret = new String[SubCommand.values().length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = SubCommand.values()[i].name().toLowerCase(Locale.ROOT);
            }
            return ret;
        }
    }
}

