/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.block.craftingstation.ContainerCraftingStation;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModMaterials;
import net.silentchaos512.gear.item.MiscUpgrades;
import net.silentchaos512.gear.item.TipUpgrades;
import net.silentchaos512.gear.item.ToolHead;
import net.silentchaos512.gear.item.ToolRods;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.item.IEnumItems;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

@JEIPlugin
public class JeiPlugin
implements IModPlugin {
    private static boolean initFailed = false;
    private Map<ResourceLocation, ItemStack> sampleStacks = new HashMap<ResourceLocation, ItemStack>();

    public static boolean hasInitFailed() {
        return initFailed;
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        initFailed = true;
        subtypeRegistry.registerSubtypeInterpreter((Item)ModItems.toolHead, ToolHead::getSubtypeKey);
        initFailed = false;
    }

    public void register(IModRegistry registry) {
        initFailed = true;
        RecipeMaker recipeMaker = SilentGear.registry.getRecipeMaker();
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.craftingStation), new String[]{"minecraft.crafting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerCraftingStation.class, "minecraft.crafting", 0, 9, 15, 54);
        registry.addRecipes(ModItems.toolHead.getExampleRecipes(), "minecraft.crafting");
        for (ICoreItem iCoreItem : ModItems.toolClasses.values()) {
            registry.addRecipes(GearHelper.getExampleRecipes(iCoreItem), "minecraft.crafting");
        }
        for (ICoreItem iCoreItem : ModItems.armorClasses.values()) {
            if (!(iCoreItem instanceof CoreArmor)) continue;
            registry.addRecipes(((CoreArmor)iCoreItem).getExampleRecipes(), "minecraft.crafting");
        }
        ArrayList<IRecipe> builtRecipes = new ArrayList<IRecipe>();
        for (ICoreItem item : ModItems.gearClasses.values()) {
            ItemStack gear = this.getSampleStack(item);
            if (item instanceof ICoreTool) {
                for (Enum enum_ : TipUpgrades.values()) {
                    if (!((TipUpgrades)enum_).getPart().isValidFor(item)) continue;
                    ItemStack gearWithTips = gear.func_77946_l();
                    GearData.addUpgradePart(gearWithTips, ItemPartData.instance(((TipUpgrades)enum_).getPart()));
                    GearData.recalculateStats(gearWithTips);
                    builtRecipes.add(recipeMaker.makeShapeless(gearWithTips, new Object[]{gear, ((TipUpgrades)enum_).getItem()}));
                }
            }
            for (Enum enum_ : MiscUpgrades.values()) {
                if (!((MiscUpgrades)enum_).getPart().isValidFor(item)) continue;
                ItemStack gearWithUpgrade = gear.func_77946_l();
                GearData.addUpgradePart(gearWithUpgrade, ItemPartData.instance(((MiscUpgrades)enum_).getPart()));
                GearData.recalculateStats(gearWithUpgrade);
                builtRecipes.add(recipeMaker.makeShapeless(gearWithUpgrade, new Object[]{gear, ((MiscUpgrades)enum_).getItem()}));
            }
        }
        registry.addRecipes(builtRecipes, "minecraft.crafting");
        this.addIngredientInfoPages(registry, SilentGear.registry.getBlocks());
        this.addIngredientInfoPages(registry, SilentGear.registry.getItems());
        registry.addIngredientInfo(ModItems.blueprints.stream().map(ItemStack::new).collect(Collectors.toList()), ItemStack.class, new String[]{this.getDescKey("blueprint")});
        registry.addIngredientInfo(Arrays.stream(TipUpgrades.values()).map(IEnumItems::getStack).collect(Collectors.toList()), ItemStack.class, new String[]{this.getDescKey("tip_upgrade")});
        for (String toolClass : ModItems.toolClasses.keySet()) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (PartMain part : PartRegistry.getMains()) {
                list.add(ModItems.toolHead.getStack(toolClass, part, true));
            }
            registry.addIngredientInfo(list, ItemStack.class, new String[]{this.getDescKey("tool_head")});
        }
        initFailed = false;
    }

    private ItemStack getSampleStack(ICoreItem gearItem) {
        ResourceLocation name = gearItem.getItem().getRegistryName();
        if (!this.sampleStacks.containsKey(name)) {
            PartDataList parts = PartDataList.of(new ItemPartData[0]);
            for (int i = 0; i < gearItem.getConfig().getHeadCount(); ++i) {
                parts.addPart(ModMaterials.mainIron);
            }
            if (gearItem.getConfig().getRodCount() > 0) {
                parts.addPart(ToolRods.WOOD.getPart());
            }
            if (gearItem.getConfig().getBowstringCount() > 0) {
                parts.addPart(ModMaterials.bowstringString);
            }
            ItemStack stack = gearItem.construct(gearItem.getItem(), parts);
            NBTTagList tagList = new NBTTagList();
            tagList.func_74742_a((NBTBase)new NBTTagString(SilentGear.i18n.translate("jei", "tooltip.sample1", new Object[0])));
            tagList.func_74742_a((NBTBase)new NBTTagString(SilentGear.i18n.translate("jei", "tooltip.sample2", new Object[0])));
            stack.func_190925_c("display").func_74782_a("Lore", (NBTBase)tagList);
            this.sampleStacks.put(name, stack);
        }
        return this.sampleStacks.get(name);
    }

    private void addIngredientInfoPages(IModRegistry registry, Collection<? extends IForgeRegistryEntry<?>> list) {
        for (IForgeRegistryEntry<?> obj : list) {
            String key = this.getDescKey(Objects.requireNonNull(obj.getRegistryName()));
            if (!SilentGear.i18n.hasKey(key)) continue;
            registry.addIngredientInfo((Object)StackHelper.fromBlockOrItem(obj), ItemStack.class, new String[]{key});
        }
    }

    private String getDescKey(String name) {
        return "jei.silentgear." + name + ".desc";
    }

    private String getDescKey(ResourceLocation name) {
        return "jei." + name.func_110624_b() + "." + name.func_110623_a() + ".desc";
    }
}

