/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.config;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.config.ConfigOptionEquipment;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.util.IAOETool;
import net.silentchaos512.lib.collection.EntityMatchList;
import net.silentchaos512.lib.collection.ItemMatchList;
import net.silentchaos512.lib.config.ConfigBaseNew;
import net.silentchaos512.lib.config.ConfigOption;
import net.silentchaos512.lib.config.ConfigOptionOreGen;
import net.silentchaos512.lib.util.I18nHelper;
import net.silentchaos512.lib.util.LogHelper;

public class Config
extends ConfigBaseNew {
    public static final Config INSTANCE = new Config();
    private static final String CAT_DEBUG = "debug";
    private static final String CAT_CLIENT = "client";
    private static final String CAT_ITEMS = "items";
    static final String CAT_GEAR = "items.gear";
    private static final String CAT_NERFED_GEAR = "items.nerfed_gear";
    private static final String CAT_SINEW = "items.sinew";
    private static final String CAT_WORLD = "world";
    private static final String CAT_WORLD_FLAX = "world.flax";
    private static final String CAT_WORLD_FLOWER = "world.flowers";
    private static final String CAT_WORLD_NETHERWOOD = "world.netherwood";
    @ConfigOption(name="Show Example Tool Heads Only", category="client")
    @ConfigOption.BooleanDefault(value=false)
    @ConfigOption.Comment(value="Show only a few example tool heads instead of all possibilities.")
    public static boolean toolHeadShowExamplesOnly;
    @ConfigOption(name="Spawn With Starter Blueprints", category="items")
    @ConfigOption.BooleanDefault(value=true)
    @ConfigOption.Comment(value="Spawn players with a blueprint package containing some starter blueprints (set false to disable). This uses the starter_blueprints loot table.")
    public static boolean spawnWithStarterBlueprints;
    public static BlueprintType blueprintTypes;
    @ConfigOption(name="Drop Rate", category="items.sinew")
    @ConfigOption.RangeFloat(value=0.2f, min=0.0f, max=1.0f)
    @ConfigOption.Comment(value="The probability an animal will drop sinew.")
    public static float sinewDropRate;
    @ConfigOption(name="Upgrades Anvil Only", category="items.gear")
    @ConfigOption.BooleanDefault(value=false)
    @ConfigOption.Comment(value="If enabled, upgrades (like tip upgrades) can only be applied in anvils.")
    public static boolean upgradesAnvilOnly;
    @ConfigOption(name="Repair Factor Anvil", category="items.gear")
    @ConfigOption.RangeFloat(value=0.5f, min=0.0f, max=1.0f)
    @ConfigOption.Comment(value="The effectiveness of anvil repairs (based on material durability). Set to 0 to disable.")
    public static float anvilRepairFactor;
    @ConfigOption(name="Repair Factor Quick", category="items.gear")
    @ConfigOption.RangeFloat(value=0.35f, min=0.0f, max=1.0f)
    @ConfigOption.Comment(value="The effectiveness of quick repairs (based on material durability). Set to 0 to disable.")
    public static float quickRepairFactor;
    @ConfigOption(name="Gear Breaks Permanently", category="items.gear")
    @ConfigOption.BooleanDefault(value=false)
    @ConfigOption.Comment(value="If enabled, tools/weapons/armor are destroyed when broken, just like vanilla.")
    public static boolean gearBreaksPermanently;
    public static IAOETool.MatchMode aoeToolMatchMode;
    public static IAOETool.MatchMode aoeToolOreMode;
    public static EntityMatchList sinewAnimals;
    private static final String SINEW_ANIMALS_COMMENT = "These entities can drop sinew. It is not restricted to animals.";
    public static ItemMatchList blockPlacerTools;
    private static final String BLOCK_PLACER_TOOLS_COMMENT = "These items will be able to place blocks by using them (right-click-to-place)";
    public static ItemMatchList itemsThatToolsCanUse;
    private static final String ITEMS_THAT_TOOLS_CAN_USE_COMMENT = "Items that block-placing tools can \"use\" by simulating a right-click.";
    public static Set<String> nerfedGear;
    private static final String NERFED_GEAR_COMMENT = "These items will have reduced durability to discourage use, but they can still be crafted and used as normal. Items from other mods can be added to the list, but I cannot guarantee their durability will actually change.";
    @ConfigOption(name="Durability Multiplier", category="items.nerfed_gear")
    @ConfigOption.RangeFloat(value=0.5f, min=0.0f, max=1.0f)
    @ConfigOption.Comment(value="The durability of items in the nerfed gear list will be multiplied by this value.")
    public static float nerfedGearMulti;
    private static List<ConfigOptionEquipment> equipmentConfigs;
    public static ConfigOptionEquipment sword;
    public static ConfigOptionEquipment dagger;
    public static ConfigOptionEquipment katana;
    public static ConfigOptionEquipment machete;
    public static ConfigOptionEquipment pickaxe;
    public static ConfigOptionEquipment shovel;
    public static ConfigOptionEquipment axe;
    public static ConfigOptionEquipment hammer;
    public static ConfigOptionEquipment excavator;
    public static ConfigOptionEquipment mattock;
    public static ConfigOptionEquipment sickle;
    public static ConfigOptionEquipment bow;
    public static ConfigOptionEquipment helmet;
    public static ConfigOptionEquipment chestplate;
    public static ConfigOptionEquipment leggings;
    public static ConfigOptionEquipment boots;
    @ConfigOption(name="Min Loss Rate", category="salvager")
    @ConfigOption.RangeDouble(value=0.0, min=0.0, max=1.0)
    @ConfigOption.Comment(value="The minimum rate of part loss when salvaging items. 0 = no loss, 1 = complete loss. Rate depends on remaining durability.")
    public static double salvagerMinLossRate;
    @ConfigOption(name="Max Loss Rate", category="salvager")
    @ConfigOption.RangeDouble(value=0.35, min=0.0, max=1.0)
    @ConfigOption.Comment(value="The maximum rate of part loss when salvaging items. 0 = no loss, 1 = complete loss. Rate depends on remaining durability.")
    public static double salvagerMaxLossRate;
    public static ConfigOptionOreGen crimsonIronOreGen;
    @ConfigOption(name="Flaxseed Drop Weight", category="world.flax")
    @ConfigOption.RangeInt(value=5, min=0)
    @ConfigOption.Comment(value="The weight of flaxseed drops. Set 0 to disable, higher numbers mean more common. Vanilla wheat seeds are 10.")
    public static int flaxseedDropWeight;
    @ConfigOption(name="Cluster Chance", category="world.flowers")
    @ConfigOption.RangeFloat(value=0.025f, min=0.0f, max=1.0f)
    @ConfigOption.Comment(value="The chance of any given chunk having a cluster of blue flowers.")
    public static float flowerClusterChance;
    @ConfigOption(name="Cluster Size", category="world.flowers")
    @ConfigOption.RangeInt(value=10, min=0, max=100)
    @ConfigOption.Comment(value="The maximum number of blue flowers per cluster. The actual number will vary, depending on the terrain and random chance.")
    public static int flowerClusterSize;
    public static int[] flowerDimensionBlacklist;
    @ConfigOption(name="Cluster Chance", category="world.netherwood")
    @ConfigOption.RangeFloat(value=0.15f, min=0.0f, max=1.0f)
    @ConfigOption.Comment(value="The chance of any given chunk having a cluster of netherwood trees.")
    public static float netherwoodClusterChance;
    @ConfigOption(name="Cluster Min Size", category="world.netherwood")
    @ConfigOption.RangeInt(value=2, min=0, max=50)
    @ConfigOption.Comment(value="The minimum number of netherwood trees to TRY TO PLACE per cluster. Must be less than max size.")
    public static int netherwoodClusterMinSize;
    @ConfigOption(name="Cluster Max Size", category="world.netherwood")
    @ConfigOption.RangeInt(value=6, min=0, max=50)
    @ConfigOption.Comment(value="The maximum number of netherwood trees per cluster. The actual number will vary, depending on the terrain and random chance.")
    public static int netherwoodClusterMaxSize;
    File directory;

    public Config() {
        super("silentgear");
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        this.directory = new File(event.getModConfigurationDirectory().getPath(), "silentchaos512/silentgear/");
        this.config = new Configuration(new File(this.directory.getPath(), "silentgear.cfg"));
        new File(this.directory.getPath(), "materials/").mkdirs();
        new File(this.directory.getPath(), "equipment/").mkdirs();
        new File(this.directory.getPath(), "traits/").mkdirs();
    }

    public void init(File file) {
        this.load();
    }

    public I18nHelper i18n() {
        return SilentGear.i18n;
    }

    public LogHelper log() {
        return SilentGear.log;
    }

    public void load() {
        try {
            super.load();
            blueprintTypes = (BlueprintType)this.loadEnum("Blueprint Types Allowed", CAT_ITEMS, BlueprintType.class, BlueprintType.BOTH, "Allow players to use blueprints, templates, or both?");
            sinewAnimals.loadConfig(this.config, "Animals That Drop Sinew", CAT_SINEW, SINEW_ANIMALS_COMMENT);
            blockPlacerTools.loadConfig(this.config, "Items That Place Blocks", CAT_ITEMS, BLOCK_PLACER_TOOLS_COMMENT);
            itemsThatToolsCanUse.loadConfig(this.config, "Items That Block Placer Tools Can Use", CAT_ITEMS, ITEMS_THAT_TOOLS_CAN_USE_COMMENT);
            aoeToolMatchMode = (IAOETool.MatchMode)this.loadEnum("AOE Tool Match Mode", CAT_GEAR, IAOETool.MatchMode.class, IAOETool.MatchMode.MODERATE, "Block matching mode for hammers and excavators. LOOSE will break any blocks the tool can harvest together (bit OP with blocks like obsidian), MODERATE will break blocks of similar harvest levels, and STRICT will only mine one block type.");
            aoeToolOreMode = (IAOETool.MatchMode)this.loadEnum("AOE Tool Ore Match Mode", CAT_GEAR, IAOETool.MatchMode.class, IAOETool.MatchMode.STRICT, "Ore matching mode for hammers and excavators, overrides standard match mode if both blocks are ores. LOOSE will break anything, MODERATE will break the same harvest level or lower, STRICT will break only the same block type.");
            this.config.setCategoryComment(CAT_NERFED_GEAR, "Settings for nerfing gear from vanilla or other mods.");
            this.config.setCategoryRequiresMcRestart(CAT_NERFED_GEAR, true);
            Object[] nerfedItems = this.config.getStringList("Nerfed Gear List", CAT_NERFED_GEAR, Config.getDefaultNerfedGear(), NERFED_GEAR_COMMENT);
            nerfedGear = ImmutableSet.copyOf((Object[])nerfedItems);
            for (ConfigOptionEquipment option : equipmentConfigs) {
                option.loadValue(this.config);
            }
            crimsonIronOreGen = new ConfigOptionOreGen("Crimson Iron Ore", -1, 24.0f, 6, 24, 120);
            crimsonIronOreGen.loadValue(this.config, CAT_WORLD);
            this.config.setCategoryComment(CAT_WORLD_FLAX, "Settings for flax and flaxseed drops");
            this.config.setCategoryRequiresMcRestart(CAT_WORLD_FLAX, true);
            flowerDimensionBlacklist = this.config.get(CAT_WORLD_FLOWER, "Dimension Blacklist", new int[0]).getIntList();
            if (netherwoodClusterMaxSize < netherwoodClusterMinSize) {
                netherwoodClusterMaxSize = netherwoodClusterMinSize;
            }
            int currentBuild = SilentGear.instance.getBuildNum();
            int n = this.config.get("last_version", "last_build", currentBuild).getInt(currentBuild);
        }
        catch (Exception ex) {
            SilentGear.log.fatal("Could not load configuration file! This could end badly...", new Object[0]);
            SilentGear.log.catching((Throwable)ex);
        }
    }

    public void save() {
        super.save();
        int buildNum = SilentGear.instance.getBuildNum();
        this.config.get("last_version", "last_build", buildNum).setValue(buildNum);
    }

    private static ConfigOptionEquipment forEquipment(ICoreItem item) {
        ConfigOptionEquipment option = new ConfigOptionEquipment(item);
        equipmentConfigs.add(option);
        return option;
    }

    private static String[] getDefaultNerfedGear() {
        ImmutableSet toolTypes = ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe", (Object)"sword");
        ImmutableSet toolMaterials = ImmutableSet.of((Object)"wooden", (Object)"stone", (Object)"iron", (Object)"golden", (Object)"diamond");
        List<String> items = toolTypes.stream().flatMap(arg_0 -> Config.lambda$getDefaultNerfedGear$1((Set)toolMaterials, arg_0)).collect(Collectors.toList());
        ImmutableSet armorTypes = ImmutableSet.of((Object)"helmet", (Object)"chestplate", (Object)"leggings", (Object)"boots");
        ImmutableSet armorMaterials = ImmutableSet.of((Object)"leather", (Object)"chainmail", (Object)"iron", (Object)"diamond", (Object)"golden");
        items.addAll(armorTypes.stream().flatMap(arg_0 -> Config.lambda$getDefaultNerfedGear$3((Set)armorMaterials, arg_0)).collect(Collectors.toList()));
        return items.toArray(new String[0]);
    }

    public File getDirectory() {
        return this.directory;
    }

    private static /* synthetic */ Stream lambda$getDefaultNerfedGear$3(Set armorMaterials, String type) {
        return armorMaterials.stream().map(material -> "minecraft:" + material + "_" + type);
    }

    private static /* synthetic */ Stream lambda$getDefaultNerfedGear$1(Set toolMaterials, String type) {
        return toolMaterials.stream().map(material -> "minecraft:" + material + "_" + type);
    }

    static {
        blueprintTypes = BlueprintType.BOTH;
        aoeToolMatchMode = IAOETool.MatchMode.MODERATE;
        aoeToolOreMode = IAOETool.MatchMode.STRICT;
        sinewAnimals = new EntityMatchList(true, false, new String[]{"minecraft:cow", "minecraft:sheep", "minecraft:pig"});
        blockPlacerTools = new ItemMatchList(true, false, new String[]{"silentgear:pickaxe", "silentgear:shovel", "silentgear:axe"});
        itemsThatToolsCanUse = new ItemMatchList(true, false, new String[]{"danknull:dank_null", "xreliquary:sojourner_staff", "torchbandolier:torch_bandolier"});
        equipmentConfigs = new ArrayList<ConfigOptionEquipment>();
        sword = Config.forEquipment(ModItems.sword);
        dagger = Config.forEquipment(ModItems.dagger);
        katana = Config.forEquipment(ModItems.katana);
        machete = Config.forEquipment(ModItems.machete);
        pickaxe = Config.forEquipment(ModItems.pickaxe);
        shovel = Config.forEquipment(ModItems.shovel);
        axe = Config.forEquipment(ModItems.axe);
        hammer = Config.forEquipment(ModItems.hammer);
        excavator = Config.forEquipment(ModItems.excavator);
        mattock = Config.forEquipment(ModItems.mattock);
        sickle = Config.forEquipment(ModItems.sickle);
        bow = Config.forEquipment(ModItems.bow);
        helmet = Config.forEquipment(ModItems.helmet);
        chestplate = Config.forEquipment(ModItems.chestplate);
        leggings = Config.forEquipment(ModItems.leggings);
        boots = Config.forEquipment(ModItems.boots);
        flowerDimensionBlacklist = new int[0];
    }
}

