/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.map.hash.THashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.config.Configuration;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.config.Config;

public class ConfigOptionEquipment {
    public final ICoreItem item;
    public final String name;
    private boolean canCraft = true;
    private boolean isVisible = true;
    private final Map<ItemStat, StatInstance> modifiers = new THashMap();
    private final Map<ItemStat, Float> baseModifiers = new THashMap();
    private final Map<String, Integer> recipe = new HashMap<String, Integer>();

    public <T extends ICoreItem> ConfigOptionEquipment(T item) {
        this.item = item;
        this.name = item.getGearClass();
    }

    public ConfigOptionEquipment loadValue(Configuration config) {
        return this.loadValue(config, "items.gear." + this.name);
    }

    public ConfigOptionEquipment loadValue(Configuration config, String category) {
        this.loadJsonResources();
        return this;
    }

    @Nonnull
    public StatInstance getBaseModifier(ItemStat stat) {
        float value = this.baseModifiers.containsKey(stat) ? this.baseModifiers.get(stat).floatValue() : 0.0f;
        return new StatInstance(this.item.getGearClass() + "_basemod", value, StatInstance.Operation.ADD);
    }

    @Nonnull
    public StatInstance getStatModifier(ItemStat stat) {
        if (this.modifiers.containsKey(stat)) {
            return this.modifiers.get(stat);
        }
        return StatInstance.ZERO;
    }

    public Set<PartType> getRequiredPartTypes() {
        return this.recipe.keySet().stream().map(PartType::get).collect(Collectors.toSet());
    }

    public int getCraftingPartCount(PartType type) {
        return this.recipe.getOrDefault(type.getName(), 0);
    }

    @Deprecated
    public int getHeadCount() {
        return this.recipe.getOrDefault("main", 0);
    }

    @Deprecated
    public int getRodCount() {
        return this.recipe.getOrDefault("rod", 0);
    }

    @Deprecated
    public int getBowstringCount() {
        return this.recipe.getOrDefault("bowstring", 0);
    }

    public boolean canCraft() {
        return this.canCraft;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    private void loadJsonResources() {
        Throwable throwable;
        BufferedReader reader;
        String path = "assets/silentgear/equipment/" + this.item.getGearClass() + ".json";
        SilentGear.log.info("Loading equipment asset file: " + path, new Object[0]);
        try {
            reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(path), "UTF-8"));
            throwable = null;
            try {
                this.readResourceFile(reader);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Exception e) {
            SilentGear.log.fatal("Error loading resource file! Either Silent screwed up or the JAR has been modified.", new Object[0]);
            SilentGear.log.fatal("    item: " + this.item, new Object[0]);
            SilentGear.log.fatal("    item type: " + this.item.getGearClass(), new Object[0]);
            e.printStackTrace();
        }
        try {
            reader = new BufferedReader(new FileReader(new File(Config.INSTANCE.directory.getPath(), "equipment/" + this.item.getGearClass() + ".json")));
            throwable = null;
            try {
                this.readResourceFile(reader);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (FileNotFoundException reader2) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readResourceFile(BufferedReader reader) {
        JsonObject obj;
        JsonElement elementBaseMods;
        JsonElement je = (JsonElement)new GsonBuilder().create().fromJson((Reader)reader, JsonElement.class);
        JsonObject json = je.getAsJsonObject();
        JsonElement elementMods = json.get("modifiers");
        if (elementMods != null && elementMods.isJsonArray()) {
            JsonArray array = elementMods.getAsJsonArray();
            for (JsonElement element : array) {
                JsonObject obj2 = element.getAsJsonObject();
                String name = obj2.has("name") ? JsonUtils.func_151200_h((JsonObject)obj2, (String)"name") : "";
                ItemStat stat = ItemStat.ALL_STATS.get(name);
                if (stat == null) continue;
                float value = obj2.has("value") ? JsonUtils.func_151217_k((JsonObject)obj2, (String)"value") : 0.0f;
                StatInstance.Operation op = obj2.has("op") ? StatInstance.Operation.byName(JsonUtils.func_151200_h((JsonObject)obj2, (String)"op")) : StatInstance.Operation.MUL1;
                String id = this.item.getGearClass() + "_mod_" + stat.getName();
                this.modifiers.put(stat, new StatInstance(id, value, op));
            }
        }
        if ((elementBaseMods = json.get("base_modifiers")) != null && elementBaseMods.isJsonObject()) {
            obj = elementBaseMods.getAsJsonObject();
            for (ItemStat stat : ItemStat.ALL_STATS.values()) {
                if (!obj.has(stat.getName().func_110623_a())) continue;
                float value = obj.get(stat.getName().func_110623_a()).getAsFloat();
                this.baseModifiers.put(stat, Float.valueOf(value));
            }
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"crafting")) {
            obj = JsonUtils.func_152754_s((JsonObject)json, (String)"crafting");
            for (PartType type : PartType.getValues()) {
                int amount = ConfigOptionEquipment.getPartCountFromJson(obj, type);
                if (amount <= 0) continue;
                this.recipe.put(type.getName(), amount);
            }
            this.canCraft = JsonUtils.func_151209_a((JsonObject)obj, (String)"can_craft", (boolean)this.canCraft);
            this.isVisible = JsonUtils.func_151209_a((JsonObject)obj, (String)"visible", (boolean)this.isVisible);
        }
    }

    private static int getPartCountFromJson(JsonObject json, PartType type) {
        String[] possibleNames;
        String[] stringArray;
        if (type == PartType.MAIN) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = type.getName();
            stringArray2[1] = type.getName() + "_count";
            stringArray = stringArray2;
            stringArray2[2] = "head_count";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = type.getName();
            stringArray = stringArray3;
            stringArray3[1] = type.getName() + "_count";
        }
        for (String name : possibleNames = stringArray) {
            if (!json.has(name)) continue;
            return json.get(name).getAsInt();
        }
        return 0;
    }
}

