/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.inventory.InventoryCraftingStation;
import net.silentchaos512.gear.item.blueprint.IBlueprint;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.recipe.RecipeBaseSL;
import net.silentchaos512.lib.util.StackHelper;

public class BlueprintCrafting
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        return new Recipe(ModItems.toolHead);
    }

    private static class Recipe
    extends RecipeBaseSL {
        Item outputType;

        Recipe(Item outputType) {
            this.outputType = outputType;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            StackList list = StackHelper.getNonEmptyStacks((IInventory)inv);
            ItemStack blueprint = list.firstOfType(IBlueprint.class);
            list.remove((Object)blueprint);
            return ((IBlueprint)blueprint.func_77973_b()).getCraftingResult(blueprint, (Collection<ItemStack>)list);
        }

        public boolean func_77569_a(InventoryCrafting inv, World world) {
            StackList list = StackHelper.getNonEmptyStacks((IInventory)inv);
            ItemStack blueprint = list.uniqueOfType(IBlueprint.class);
            if (blueprint.func_190926_b()) {
                return false;
            }
            Collection materials = list.allMatches(s -> PartRegistry.get(s) != null);
            int materialCount = materials.size();
            IBlueprint blueprintItem = (IBlueprint)blueprint.func_77973_b();
            if (materialCount + 1 != list.size() || materialCount != blueprintItem.getMaterialCost(blueprint)) {
                return false;
            }
            return Recipe.inventoryAllowsMixedMaterial(inv) || materials.stream().map(PartRegistry::get).distinct().count() == 1L;
        }

        @Nonnull
        public ItemStack func_77571_b() {
            return new ItemStack(this.outputType);
        }

        private static boolean inventoryAllowsMixedMaterial(InventoryCrafting inv) {
            return inv instanceof InventoryCraftingStation;
        }
    }
}

