/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.parts.RepairContext;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.recipe.RecipeBaseSL;
import net.silentchaos512.lib.util.StackHelper;

public class QuickRepair
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        return new Recipe();
    }

    private static class Recipe
    extends RecipeBaseSL {
        private Recipe() {
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            ItemStack gear = ItemStack.field_190927_a;
            int partsCount = 0;
            for (ItemStack stack : StackList.fromInventory((IInventory)inv)) {
                if (stack.func_77973_b() instanceof ICoreItem) {
                    if (gear.func_190926_b()) {
                        gear = stack;
                        continue;
                    }
                    return false;
                }
                if (PartRegistry.get(stack) != null) {
                    ++partsCount;
                    ItemPartData data = ItemPartData.fromStack(stack);
                    if (data != null && !(data.getRepairAmount(gear, RepairContext.QUICK) <= 0.0f)) continue;
                    return false;
                }
                return false;
            }
            return !gear.func_190926_b() && partsCount > 0;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            StackList list = StackHelper.getNonEmptyStacks((IInventory)inv);
            ItemStack gear = list.uniqueOfType(ICoreItem.class).func_77946_l();
            Collection parts = list.allMatches(s -> PartRegistry.get(s) != null);
            if (gear.func_190926_b() || parts.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            float repairValue = 0.0f;
            int materialCount = 0;
            for (ItemStack stack : parts) {
                ItemPartData data = ItemPartData.fromStack(stack);
                if (data == null) continue;
                repairValue += data.getRepairAmount(gear, RepairContext.QUICK);
                ++materialCount;
            }
            repairValue += 1.0f;
            if (gear.func_77973_b() instanceof ICoreItem) {
                repairValue *= GearData.getStat(gear, CommonItemStats.REPAIR_EFFICIENCY);
            }
            gear.func_96631_a(-Math.round(repairValue), SilentGear.random, null);
            GearData.incrementRepairCount(gear, materialCount);
            GearData.recalculateStats(gear);
            return gear;
        }

        public ItemStack func_77571_b() {
            return ItemStack.field_190927_a;
        }
    }
}

