/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.item.ToolHead;
import net.silentchaos512.lib.recipe.RecipeBaseSL;

public class RecipeModularItem
extends RecipeBaseSL {
    private final ICoreItem item;

    public RecipeModularItem(ICoreItem item) {
        this.item = item;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        Collection<ItemStack> parts = this.getComponents(inv);
        return this.getCraftingResult(parts);
    }

    public ItemStack getCraftingResult(Collection<ItemStack> parts) {
        ArrayList<ItemPartData> data = new ArrayList<ItemPartData>();
        HashMap<PartType, ItemPartData> partsByType = new HashMap<PartType, ItemPartData>();
        for (ItemStack stack : parts) {
            ItemPartData part = ItemPartData.fromStack(stack);
            if (stack.func_77973_b() instanceof ToolHead) {
                if (!ToolHead.getToolClass(stack).equals(this.item.getGearClass())) {
                    return ItemStack.field_190927_a;
                }
                data.addAll(ToolHead.getAllParts(stack));
                continue;
            }
            if (part == null) continue;
            PartType type = part.getPart().getType();
            if (partsByType.containsKey(type) && ((ItemPartData)partsByType.get(type)).getPart() != part.getPart()) {
                return ItemStack.field_190927_a;
            }
            partsByType.put(part.getPart().getType(), part);
        }
        data.addAll(partsByType.values());
        return this.item.construct((Item)this.item, data);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        Collection<ItemStack> parts = this.getComponents(inv);
        return this.item.matchesRecipe(parts) && parts.size() == RecipeModularItem.getNonEmptyStacks((InventoryCrafting)inv).size();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((Item)this.item);
    }

    private Collection<ItemStack> getComponents(InventoryCrafting inv) {
        ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
        parts.addAll(this.getComponents(inv, s -> s.func_77973_b() instanceof ToolHead));
        parts.addAll(this.getComponents(inv, s -> PartRegistry.get(s) != null));
        return parts;
    }

    private Collection<ItemStack> getComponents(InventoryCrafting inv, Predicate<ItemStack> predicate) {
        ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !predicate.test(stack)) continue;
            parts.add(stack);
        }
        return parts;
    }
}

