/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.recipe.RecipeBaseSL;

public class RoughTool
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = recipe.getRecipeWidth();
        primer.height = recipe.getRecipeHeight();
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = recipe.func_192400_c();
        JsonObject resultObj = json.getAsJsonObject("result");
        Item item = Item.func_111206_d((String)JsonUtils.func_151219_a((JsonObject)resultObj, (String)"item", (String)""));
        if (item == null) {
            throw new JsonSyntaxException("item does not exist");
        }
        if (!(item instanceof ICoreItem)) {
            throw new JsonSyntaxException("item is not a gear item");
        }
        ItemStack result = new ItemStack(item);
        ShapedOreRecipe baseRecipe = new ShapedOreRecipe(new ResourceLocation("silentgear", "rough_tools"), result, primer);
        return new Recipe(baseRecipe);
    }

    private static class Recipe
    extends RecipeBaseSL {
        private final ShapedOreRecipe baseRecipe;

        Recipe(ShapedOreRecipe baseRecipe) {
            this.baseRecipe = baseRecipe;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return this.baseRecipe.func_77569_a(inv, worldIn);
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            StackList list = StackList.fromInventory((IInventory)inv);
            Collection parts = list.allMatches(s -> PartRegistry.get(s) != null).stream().map(ItemPartData::fromStack).collect(Collectors.toList());
            ICoreItem item = (ICoreItem)this.baseRecipe.func_77571_b().func_77973_b();
            return item.construct(item.getItem(), parts);
        }

        public ItemStack func_77571_b() {
            return this.baseRecipe.func_77571_b();
        }
    }
}

