/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.recipe.RecipeBaseSL;

public class UpgradeGear
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        return new Recipe();
    }

    private static class Recipe
    extends RecipeBaseSL {
        private Recipe() {
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            ItemStack tool = ItemStack.field_190927_a;
            ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
            for (ItemStack stack : Recipe.getNonEmptyStacks((InventoryCrafting)inv)) {
                ItemPartData partData = ItemPartData.fromStack(stack);
                if (stack.func_77973_b() instanceof ICoreItem) {
                    tool = stack.func_77946_l();
                    continue;
                }
                if (partData == null || !(partData.getPart() instanceof IUpgradePart)) continue;
                upgrades.add(stack);
            }
            if (tool.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            for (ItemStack upgrade : upgrades) {
                GearData.addUpgradePart(tool, upgrade);
            }
            GearData.recalculateStats(tool);
            return tool;
        }

        public ItemStack func_77571_b() {
            return ItemStack.field_190927_a;
        }

        public boolean func_77569_a(InventoryCrafting inv, World world) {
            if (Config.upgradesAnvilOnly) {
                return false;
            }
            boolean foundTool = false;
            boolean foundUpgrade = false;
            for (ItemStack stack : Recipe.getNonEmptyStacks((InventoryCrafting)inv)) {
                ItemPartData partData = ItemPartData.fromStack(stack);
                if (stack.func_77973_b() instanceof ICoreItem) {
                    if (foundTool) {
                        return false;
                    }
                    foundTool = true;
                    continue;
                }
                if (partData != null && partData.getPart() instanceof IUpgradePart) {
                    foundUpgrade = true;
                    continue;
                }
                return false;
            }
            return foundTool && foundUpgrade;
        }
    }
}

