/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.init.ModTraits;
import net.silentchaos512.gear.util.TraitHelper;

@Mod.EventBusSubscriber
public final class GearEvents {
    private static final Set<UUID> entityAttackedThisTick = new HashSet<UUID>();

    private GearEvents() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent events) {
        entityAttackedThisTick.clear();
    }

    @SubscribeEvent
    public static void onAttackEntity(LivingAttackEvent event) {
        EntityLivingBase attacked = event.getEntityLiving();
        if (attacked == null || entityAttackedThisTick.contains(attacked.getPersistentID())) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity attacker = source.func_76346_g();
        if (!(attacker instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)attacker;
        ItemStack weapon = player.func_184614_ca();
        if (!(weapon.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        float baseDamage = event.getAmount();
        float newDamage = TraitHelper.activateTraits(weapon, baseDamage, (trait, level, value) -> trait.onAttackEntity(player, attacked, level, weapon, baseDamage));
        if (Math.abs(newDamage - baseDamage) > 1.0E-4f) {
            event.setCanceled(true);
            entityAttackedThisTick.add(attacked.getPersistentID());
            attacked.func_70097_a(source, newDamage);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack tool = player.func_184614_ca();
        if (tool.func_77973_b() instanceof ICoreItem) {
            boolean canHarvest;
            IBlockState state = event.getState();
            String toolClass = state.func_177230_c().getHarvestTool(state);
            if (toolClass == null) {
                toolClass = "";
            }
            int blockLevel = state.func_177230_c().getHarvestLevel(state);
            int toolLevel = tool.func_77973_b().getHarvestLevel(tool, toolClass, player, state);
            boolean bl = canHarvest = toolLevel >= blockLevel;
            if (canHarvest) {
                int level = TraitHelper.getTraitLevel(tool, ModTraits.speedBoostLight);
                float light = GearEvents.getAreaLightBrightness(player.field_70170_p, player.func_180425_c());
                event.setNewSpeed(event.getOriginalSpeed() + (float)(3 * level) * light);
            }
        }
    }

    public static float getAreaLightBrightness(World world, BlockPos pos) {
        float value = world.func_175724_o(pos);
        value = Math.max(value, world.func_175724_o(pos.func_177978_c()));
        value = Math.max(value, world.func_175724_o(pos.func_177968_d()));
        value = Math.max(value, world.func_175724_o(pos.func_177974_f()));
        value = Math.max(value, world.func_175724_o(pos.func_177976_e()));
        value = Math.max(value, world.func_175724_o(pos.func_177978_c().func_177976_e()));
        value = Math.max(value, world.func_175724_o(pos.func_177978_c().func_177974_f()));
        value = Math.max(value, world.func_175724_o(pos.func_177968_d().func_177976_e()));
        value = Math.max(value, world.func_175724_o(pos.func_177968_d().func_177974_f()));
        return value;
    }

    @SubscribeEvent
    public static void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.isSilkTouching() || event.getHarvester() == null) {
            return;
        }
        ItemStack tool = event.getHarvester().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int magmaticLevel = TraitHelper.getTraitLevel(tool, ModTraits.magmatic);
        if (magmaticLevel == 0) {
            return;
        }
        for (int i = 0; i < event.getDrops().size(); ++i) {
            ItemStack stack = (ItemStack)event.getDrops().get(i);
            ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(stack);
            if (smelted.func_190926_b()) continue;
            event.getDrops().remove(i);
            event.getDrops().add(i, smelted.func_77946_l());
        }
    }

    @SubscribeEvent
    public static void onXpDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        ItemStack tool = event.getAttackingPlayer().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, ModTraits.ancient);
        if (ancientLevel == 0) {
            return;
        }
        int bonusXp = (int)((float)event.getOriginalExperience() * 0.25f * (float)ancientLevel);
        event.setDroppedExperience(event.getDroppedExperience() + bonusXp);
    }

    @SubscribeEvent
    public static void onBlockXpDrop(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack tool = event.getPlayer().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, ModTraits.ancient);
        if (ancientLevel == 0) {
            return;
        }
        int bonusXp = (int)((float)event.getExpToDrop() * 0.25f * (float)ancientLevel);
        event.setExpToDrop(event.getExpToDrop() + bonusXp);
    }
}

