/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.RepairContext;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.advancements.LibTriggers;

public class RepairHandler {
    public static final RepairHandler INSTANCE = new RepairHandler();
    private static final ResourceLocation APPLY_TIP_UPGRADE = new ResourceLocation("silentgear", "apply_tip_upgrade");
    private static final ResourceLocation MAX_DURABILITY = new ResourceLocation("silentgear", "max_durability");
    private static final ResourceLocation REPAIR_FROM_BROKEN = new ResourceLocation("silentgear", "repair_from_broken");

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemPartData part;
        if (event.getLeft().func_77973_b() instanceof ICoreItem && (part = ItemPartData.fromStack(event.getRight())) != null) {
            if (part.getPart() instanceof IUpgradePart) {
                this.handleUpgradeApplication(event, part);
            } else if (part.isMain()) {
                this.handleGearRepair(event, part);
            }
        }
    }

    private void handleUpgradeApplication(AnvilUpdateEvent event, ItemPartData part) {
        ItemStack result = event.getLeft().func_77946_l();
        GearData.addUpgradePart(result, part);
        GearData.recalculateStats(result);
        event.setOutput(result);
        event.setCost(3);
    }

    private void handleGearRepair(AnvilUpdateEvent event, ItemPartData part) {
        ItemStack result = event.getLeft().func_77946_l();
        float amount = part.getRepairAmount(result, RepairContext.ANVIL);
        int materialCount = 1;
        for (float repaired = amount *= GearData.getStat(result, CommonItemStats.REPAIR_EFFICIENCY); materialCount < event.getRight().func_190916_E() && repaired < (float)result.func_77952_i(); ++materialCount, repaired += amount) {
        }
        if (amount > 0.0f) {
            result.func_96631_a(-Math.round(amount * (float)materialCount), SilentGear.random, null);
            GearData.recalculateStats(result);
            event.setOutput(result);
            event.setCost(materialCount);
            event.setMaterialCost(materialCount);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (!(event.crafting.func_77973_b() instanceof ICoreItem)) {
            return;
        }
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int brokenCount = GearData.getBrokenCount(event.crafting);
            int repairCount = GearData.getRepairCount(event.crafting);
            if (brokenCount > 0 && repairCount > 0) {
                LibTriggers.GENERIC_INT.trigger(player, REPAIR_FROM_BROKEN, brokenCount);
            }
            LibTriggers.GENERIC_INT.trigger(player, MAX_DURABILITY, event.crafting.func_77958_k());
            if (!GearData.getConstructionParts(event.crafting).getTips().isEmpty()) {
                LibTriggers.GENERIC_INT.trigger(player, APPLY_TIP_UPGRADE, 1);
            }
        }
    }
}

