/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.util.GearHelper;

public class ToolBlockPlaceHandler {
    public static final ToolBlockPlaceHandler INSTANCE = new ToolBlockPlaceHandler();

    private ToolBlockPlaceHandler() {
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos targetPos;
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b() || !this.canToolPlaceBlock(stack)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_70093_af()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EnumFacing side = event.getFace();
        ItemStack stackOffHand = player.func_184592_cb();
        if (!stackOffHand.func_190926_b() && stackOffHand.func_77973_b() instanceof ItemBlock && side != null && !this.canPlaceBlockAt(stackOffHand, player, world, pos, side)) {
            return;
        }
        int toolSlot = player.field_71071_by.field_70461_c;
        int itemSlot = toolSlot + 1;
        ItemStack nextStack = ItemStack.field_190927_a;
        ItemStack lastStack = player.field_71071_by.func_70301_a(8);
        if (toolSlot < 8 && this.itemNotPlaceable(nextStack = player.field_71071_by.func_70301_a(itemSlot))) {
            nextStack = lastStack;
            itemSlot = 8;
            if (this.itemNotPlaceable(nextStack)) {
                return;
            }
        }
        Item item = nextStack.func_77973_b();
        BlockPos blockPos = targetPos = side != null ? pos.func_177972_a(side) : pos;
        if (item instanceof ItemBlock) {
            int px = targetPos.func_177958_n();
            int py = targetPos.func_177956_o();
            int pz = targetPos.func_177952_p();
            AxisAlignedBB blockBounds = new AxisAlignedBB((double)px, (double)py, (double)pz, (double)(px + 1), (double)(py + 1), (double)(pz + 1));
            AxisAlignedBB playerBounds = player.func_174813_aQ();
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.func_179223_d();
            IBlockState state = block.func_176203_a(itemBlock.getMetadata(nextStack));
            if (state.func_185904_a().func_76230_c() && playerBounds.func_72326_a(blockBounds)) {
                return;
            }
        }
        int prevSize = nextStack.func_190916_E();
        Vec3d hit = event.getHitVec();
        EnumActionResult result = this.useItemAsPlayerMainHand(nextStack, player, world, pos, side, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c);
        if (result == EnumActionResult.SUCCESS) {
            player.func_184609_a(EnumHand.MAIN_HAND);
        }
        if (player.field_71075_bZ.field_75098_d) {
            nextStack.func_190920_e(prevSize);
        }
        if (nextStack.func_190926_b()) {
            nextStack = ItemStack.field_190927_a;
            player.field_71071_by.func_70299_a(itemSlot, ItemStack.field_190927_a);
        }
    }

    private EnumActionResult useItemAsPlayerMainHand(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack currentEquipped = player.func_184614_ca();
        player.func_184611_a(EnumHand.MAIN_HAND, stack);
        EnumActionResult result = stack.func_77973_b().func_180614_a(player, world, pos, EnumHand.MAIN_HAND, facing, hitX, hitY, hitZ);
        player.func_184611_a(EnumHand.MAIN_HAND, currentEquipped);
        return result;
    }

    private boolean canToolPlaceBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ICoreItem && GearHelper.isBroken(stack)) {
            return false;
        }
        return Config.blockPlacerTools.matches((Object)item);
    }

    private boolean canPlaceBlockAt(ItemStack blockStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        Block block = ((ItemBlock)blockStack.func_77973_b()).func_179223_d();
        if (block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        return player.func_175151_a(pos, side, blockStack) && world.func_190527_a(block, pos, false, side, (Entity)player);
    }

    private boolean itemNotPlaceable(ItemStack stack) {
        return stack.func_190926_b() || stack.func_77942_o() && stack.func_77978_p().func_74764_b("NoPlacing") || !(stack.func_77973_b() instanceof ItemBlock) && !Config.itemsThatToolsCanUse.matches((Object)stack.func_77973_b());
    }
}

