/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gear.GuideBookToolMod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.item.BlueprintPackage;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.Flaxseeds;
import net.silentchaos512.gear.item.MiscUpgrades;
import net.silentchaos512.gear.item.NetherBanana;
import net.silentchaos512.gear.item.TestItem;
import net.silentchaos512.gear.item.TipUpgrades;
import net.silentchaos512.gear.item.ToolHead;
import net.silentchaos512.gear.item.blueprint.Blueprint;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBook;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.item.gear.CoreAxe;
import net.silentchaos512.gear.item.gear.CoreBow;
import net.silentchaos512.gear.item.gear.CoreDagger;
import net.silentchaos512.gear.item.gear.CoreExcavator;
import net.silentchaos512.gear.item.gear.CoreHammer;
import net.silentchaos512.gear.item.gear.CoreKatana;
import net.silentchaos512.gear.item.gear.CoreMachete;
import net.silentchaos512.gear.item.gear.CoreMattock;
import net.silentchaos512.gear.item.gear.CorePickaxe;
import net.silentchaos512.gear.item.gear.CoreShovel;
import net.silentchaos512.gear.item.gear.CoreSickle;
import net.silentchaos512.gear.item.gear.CoreSword;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.item.IEnumItems;
import net.silentchaos512.lib.item.ItemGuideBookSL;
import net.silentchaos512.lib.registry.SRegistry;

public final class ModItems {
    public static final Map<String, ICoreTool> toolClasses = new LinkedHashMap<String, ICoreTool>();
    public static final Map<String, ICoreArmor> armorClasses = new LinkedHashMap<String, ICoreArmor>();
    public static final Map<String, ICoreItem> gearClasses = new LinkedHashMap<String, ICoreItem>();
    public static final List<Blueprint> blueprints = new ArrayList<Blueprint>();
    public static ItemGuideBookSL guideBook = new ItemGuideBookSL((GuideBook)new GuideBookToolMod());
    public static BlueprintPackage blueprintPackage = new BlueprintPackage(new ResourceLocation("silentgear", "starter_blueprints"));
    public static BlueprintBook blueprintBook = new BlueprintBook();
    public static Flaxseeds flaxseeds = new Flaxseeds();
    public static NetherBanana netherBanana = new NetherBanana();
    public static ToolHead toolHead = new ToolHead();
    public static CoreSword sword = new CoreSword();
    public static CoreDagger dagger = new CoreDagger();
    public static CoreKatana katana = new CoreKatana();
    public static CoreMachete machete = new CoreMachete();
    public static CorePickaxe pickaxe = new CorePickaxe();
    public static CoreShovel shovel = new CoreShovel();
    public static CoreAxe axe = new CoreAxe();
    public static CoreHammer hammer = new CoreHammer();
    public static CoreExcavator excavator = new CoreExcavator();
    public static CoreMattock mattock = new CoreMattock();
    public static CoreSickle sickle = new CoreSickle();
    public static CoreBow bow = new CoreBow();
    public static CoreArmor helmet = new CoreArmor(EntityEquipmentSlot.HEAD, "helmet");
    public static CoreArmor chestplate = new CoreArmor(EntityEquipmentSlot.CHEST, "chestplate");
    public static CoreArmor leggings = new CoreArmor(EntityEquipmentSlot.LEGS, "leggings");
    public static CoreArmor boots = new CoreArmor(EntityEquipmentSlot.FEET, "boots");

    private ModItems() {
    }

    public static void registerAll(SRegistry reg) {
        ModItems.guideBook.giveBookOnFirstLogin = false;
        toolClasses.put("sword", sword);
        toolClasses.put("dagger", dagger);
        toolClasses.put("katana", katana);
        toolClasses.put("machete", machete);
        toolClasses.put("pickaxe", pickaxe);
        toolClasses.put("shovel", shovel);
        toolClasses.put("axe", axe);
        toolClasses.put("hammer", hammer);
        toolClasses.put("excavator", excavator);
        toolClasses.put("mattock", mattock);
        toolClasses.put("sickle", sickle);
        toolClasses.put("bow", bow);
        armorClasses.put("helmet", helmet);
        armorClasses.put("chestplate", chestplate);
        armorClasses.put("leggings", leggings);
        armorClasses.put("boots", boots);
        gearClasses.putAll(toolClasses);
        gearClasses.putAll(armorClasses);
        IEnumItems.RegistrationHelper enumItems = new IEnumItems.RegistrationHelper(reg);
        reg.registerItem((Item)guideBook, "guide_book");
        reg.registerItem((Item)blueprintPackage, "blueprint_package");
        ModItems.registerBlueprints(reg, "blueprint", false);
        ModItems.registerBlueprints(reg, "template", true);
        reg.registerItem((Item)blueprintBook, "blueprint_book");
        enumItems.registerItems((IEnumItems[])TipUpgrades.values());
        enumItems.registerItems((IEnumItems[])MiscUpgrades.values());
        enumItems.registerItems((IEnumItems[])CraftingItems.values());
        reg.registerItem((Item)flaxseeds, "flaxseeds");
        reg.registerItem((Item)netherBanana, "nether_banana");
        reg.registerItem((Item)toolHead, "tool_head");
        toolClasses.forEach((key, item) -> reg.registerItem(item.getItem(), key));
        armorClasses.forEach((key, item) -> reg.registerItem(item.getItem(), key));
        if (SilentGear.instance.getBuildNum() == 0) {
            reg.registerItem((Item)new TestItem(), "test_item");
        }
        ModItems.registerOreDictEntries();
        ModItems.addSmeltingRecipes();
    }

    private static void registerOreDictEntries() {
        OreDictionary.registerOre((String)"flint", (Item)Items.field_151145_ak);
        CraftingItems.registerOreDict();
    }

    private static void addSmeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)CraftingItems.SINEW.getStack(), (ItemStack)CraftingItems.DRIED_SINEW.getStack(), (float)0.1f);
    }

    private static void registerBlueprints(SRegistry reg, String name, boolean singleUse) {
        toolClasses.forEach((key, item) -> {
            Blueprint blueprint = new Blueprint(singleUse, (ICoreItem)item, partList -> toolHead.getStack((String)key, (PartDataList)partList));
            blueprints.add(blueprint);
            reg.registerItem((Item)blueprint, name + "_" + key);
        });
        armorClasses.forEach((key, item) -> {
            Blueprint blueprint = new Blueprint(singleUse, (ICoreItem)item, partList -> item.construct(item.getItem(), (Collection<ItemPartData>)partList));
            blueprints.add(blueprint);
            reg.registerItem((Item)blueprint, name + "_" + key);
        });
        Item item2 = new Item();
        if (!singleUse) {
            item2.func_77642_a(item2);
        }
        reg.registerItem(item2, name + "_rod");
        OreDictionary.registerOre((String)"blueprintRod", (Item)item2);
    }
}

